/*
 * Copyright (C) 2010-2011 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <linux/types.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/pm.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/init.h>
#include <linux/input.h>
#include <linux/nodemask.h>
#include <linux/clk.h>
#include <linux/platform_device.h>
#include <linux/fsl_devices.h>

#include <linux/ft5x06_i2c_defs.h>
#include <linux/ds2782_battery.h>

#include <linux/spi/spi.h>
#include <linux/i2c.h>
#include <linux/ata.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>
#include <linux/mtd/partitions.h>
#include <linux/regulator/consumer.h>
#include <linux/android_pmem.h>
#include <linux/usb/android_composite.h>
#include <linux/pmic_external.h>
#include <linux/pmic_status.h>
#include <linux/ipu.h>
#include <linux/mxcfb.h>
#include <linux/pwm_backlight.h>
#include <linux/fec.h>
#include <linux/powerkey.h>
#include <linux/ahci_platform.h>
#include <linux/gpio_keys.h>
#include <linux/mfd/da9052/da9052.h>
#include <mach/common.h>
#include <mach/hardware.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/time.h>
#include <asm/mach/keypad.h>
#include <asm/mach/flash.h>
#include <mach/memory.h>
#include <mach/gpio.h>
#include <mach/mmc.h>
#include <mach/mxc_dvfs.h>
#include <mach/iomux-mx53.h>
#include <mach/i2c.h>
#include <mach/mxc_iim.h>
#include <mach/check_fuse.h>

#include "crm_regs.h"
#include "devices.h"
#include "usb.h"
#include "pmic.h"
#include "linux/crestron.h"
//#include "linux/uihal_file.h"

//#define DEBUG_AMP    //RJK if defined you need to do manual amp pwr_on
#undef DEBUG_AMP

#define CONFIG_TSW750 //DMM
//#define NO_1050_LCD //RJK uncomment for LCD debug only

// Declared extern in linux/crestron.h, defined here.
int gProductId=0;
int gProductRev=0;

/*!
 * @file mach-mx5/mx53_loco.c
 *
 * @brief This file contains MX53 loco board specific initialization routines.
 *
 * @ingroup MSL_MX53
 */

/* MX53 LOCO GPIO PIN configurations */
#define NVDD_FAULT			(0*32 + 5)	/* GPIO_1_5 */

#define FEC_INT				(1*32 + 4)	/* GPIO_2_4 */
//RJK HEADPHONE_DEC_B conflicts IR
#define HEADPHONE_DEC_B			(1*32 + 5)	/* GPIO_2_5 */
#define MIC_DEC_B			(1*32 + 6)	/* GPIO_2_6 */
#define USER_UI1			(1*32 + 14)	/* GPIO_2_14 */
#define USER_UI2			(1*32 + 15)	/* GPIO_2_15 */
#define MX53_nONKEY			(0*32 + 8)	/* GPIO_1_8 */

#define SD3_CD_N			(2*32 + 11)	/* GPIO_3_11 */
#define SD3_WP				(2*32 + 12)	/* GPIO_3_12 */
#define DISP0_DET_INT			(2*32 + 31)	/* GPIO_3_31 */
/* display reset NU on tst600*/
#define DISP0_RESET			(4*32 + 0)	/* GPIO_5_0 */

/* power/Battery */
#define EXT_PWR_N			(1*32 + 30)	/* GPIO_2_30 */
#define WD_ENABLE			(2*32 + 26)	/* GPIO_3_26 */


/* tst600 product ID pins */
#define PROD_ID5			(5*32 + 12)	/* GPIO_6_12 */		
#define PROD_ID4			(5*32 + 11)	/* GPIO_6_11 */		
#define PROD_ID3			(5*32 + 10)	/* GPIO_6_10 */		
#define PROD_ID2			(5*32 + 9)	/* GPIO_6_9 */		
#define PROD_ID1			(5*32 + 8)	/* GPIO_6_8 */		
#define PROD_ID0			(5*32 + 7)	/* GPIO_6_7 */		

/* tst600 product REV pins */
#define PROD_REV3			(5*32 + 16)	/* GPIO_6_16 */		
#define PROD_REV2			(5*32 + 15)	/* GPIO_6_15 */		
#define PROD_REV1			(5*32 + 14)	/* GPIO_6_14 */		
#define PROD_REV0			(5*32 + 13)	/* GPIO_6_13 */		

/* RJK added for key switch controller */
#define KEY_INT_N			(2*32 + 15)	/* GPIO_3_15 */

#define POWER_5V_ON			(5*32 + 17)     /* GPIO_6_17 */ 
#define POWER_12V_ON			(5*32 + 18)     /* GPIO_6_18 */ 

#define FEC_RST				(6*32 + 6)	/* GPIO_7_6 */
#define USER_LED_EN			(6*32 + 7)	/* GPIO_7_7 */
//#define USB_PWREN			(6*32 + 8)	/* GPIO_7_8 */

//GPIO_7_11 defined in mx53_loco_pmic_da9053.c as MX53_LOCO_DA9052_IRQ
#define NIRQ				(6*32 + 11)	/* GPIO7_11 */

#define MX53_LOCO_MC34708_IRQ_REVA    (4*32 + 30)	/* GPIO5_30 */
#define MX53_LOCO_MC34708_IRQ_REVB    (4*32 + 23)	/* GPIO5_23 */
/* added for FEC */
#define MHZ_50_OSC_EN			(6*32 + 0)     /* GPIO_7_0 */ 
#define FEC_PWR_ON			(0*32 + 2)     /* GPIO_1_2 */ 

/* audio tlv320aic3254 */
#define CODEC_INT_OUT			(6*32 + 9)      /* GPIO_7_9 */	
/* DMM TODO: Generalize audio for different panels, 
 * best if I can pass the pin to the driver. See 750 and 1050 sections for redef of pin. */
#define CODEC_RESET_N			(6*32 + 8)      /* GPIO_7_8 */	
#define AMP_SD_N			(6*32 + 3)      /* GPIO_7_3 */	
#define I2S_LRCLK			(3*32 + 8)      /* GPIO_4_8 */	
#define I2S_SCLK			(3*32 + 6)      /* GPIO_4_6 */	
#define I2S_DOUT			(3*32 + 7)      /* GPIO_4_7 */	
#define I2S_DIN				(3*32 + 9)      /* GPIO_4_9 */	

#define CAP_TS_RST_N			(2*32 + 3)	/* GPIO_3_3 */
#define CAP_TS_INT_N			(2*32 + 4)	/* GPIO_3_4 */

#define MX53_OFFSET					(0x20000000)
#define TZIC_WAKEUP0_OFFSET         (0x0E00)
#define TZIC_WAKEUP1_OFFSET         (0x0E04)
#define TZIC_WAKEUP2_OFFSET         (0x0E08)
#define TZIC_WAKEUP3_OFFSET         (0x0E0C)
#define GPIO7_0_11_IRQ_BIT			(0x1<<11)

/**
 * tsw550 gpio
 */
#define DISPL_BUF_EN_3V3_N		(0*32 + 12)     /* GPIO_1_12 */
#define DISP1_STANDBY_N			(3*32 + 20)     /* GPIO_4_20 */

/**
 * tst600 gpio
 */
#define GG_PROG_PULSE		(2*32 + 25)		/* GPIO_3_25 */
#define ACT_STBY			(2*32 + 27)		/* GPIO_3_27 */
/* RJK added for display */
// Defines
#define DISP0_POWER_EN		(2*32 + 24)		/* GPIO_3_24 */
#define LCD_BK_PWR_EN		(0*32 + 13)		/* GPIO_1_13 */
#define DISPL_BUF_EN_N		(0*32 + 12)     /* GPIO_1_12 */
#define LCD_BK_ON           (6*32 + 2)      /* GPIO_7_2 */
#define LCD_BLT_EN          (6*32 + 2)      /* GPIO_7_2 */
#define LCD_V_FLIP			(0*32 + 15)     /* GPIO_1_15 */
#define LCD_H_FLIP			(0*32 + 14)     /* GPIO_1_14 */

#define DOCK_CHG_INDICATOR	(6*32 + 10)     /* GPIO_7_10 */
/*added for wifi  */
#define WIFI_ON				(2*32 + 5)      /* GPIO_3_5 */
/* RJK added for Touchscreen */
#define BKLIGHT_CTRL		(2*32 + 28)		/* GPIO_3_28 */

/**
 * tsw750 gpio
 */
//DMM 750
#define DISP1_BKLT_EN_3V3		(0*32 + 13)	/* GPIO_1_13 (13)*/
#define DISP1_POWER_3V3			(0*32 + 14)	/* GPIO_1_14 (14)*/
#define DISP1_HSYNC_2V775       (3*32 + 18) // GPIO_4_18
#define DISP1_VSYNC_2V775       (3*32 + 19) // GPIO_4_19
#define LCD_BUFF_EN 			(4*32 + 15)	/* GPIO_5_15 (143)*/
#define DISP1_RL_2V775          (4*32 + 16) /* GPIO_5_16 (144)*/
#define DISP1_UD_2V775          (4*32 + 17) /* GPIO_5_17 (145)*/


/**
 * tsw1050 gpio
 */


/**
 * 750 and 1050
 */
#if 0 //RJK for reference only
// For TSW-1050 on WinCE
	#define LCD_BK_ON_TSW1050_GPIO_PIN			13	// MCU1_13
	#define DISP0_POWER_EN_TSW1050_GPIO_PIN			14	// MCU1_14
	#define DSPL_BUF_EN_N_TSW1050_GPIO_PIN			15	// MCU5_15
	#define VLED_SIG_EN_TSW1050_GPIO_PIN			10	// MCU7_10
	#define VLED_POWER_EN_TSW1050_GPIO_PIN			12	// MCU2_12
	#define LCD_PWM_EN_TSW1050_GPIO_PIN				1	// MCU1_1
#endif
//redef'd below  #define LCD_BLT_EN_1050          (0*32 + 13)      /* GPIO_1_13 */
#define DISP1_BKLT_EN_3V3		(0*32 + 13)	/* GPIO_1_13 (13)*/
#define DISP1_POWER_3V3			(0*32 + 14)	/* GPIO_1_14 (14)*/
#define LCD_BUFF_EN 			(4*32 + 15)	/* GPIO_5_15 (143)*/
#define VLED_EN_3V3 			(1*32 + 12) /* GPIO_2_12 (44)*/
#define VLED_SIG_EN            	(6*32 + 10) /* GPIO_7_10 (202)*/
/* DMM TODO: Redef of CODEC_RESET_N, best if we could pass this to the driver. */
#define CODEC_RST_3V3_N			(1*32 + 10)     // GPIO_2_10
#define LEDS_RST_3V3            (1*32 + 7)  	// GPIO_2_7
#define MIC_SEL_3V3             (1*32 + 13) 	// GPIO_2_13

extern void pm_i2c_init(u32 base_addr);
static u32 mx53_loco_mc34708_irq;

/** 
 * Pads common between the 600, 750, and 1050 touchpanels.
 */
static iomux_v3_cfg_t mx53_loco_pads[] = {
	/* WDT */
	MX53_PAD_EIM_D26__GPIO3_26,

	/* FEC */
	MX53_PAD_FEC_MDC__FEC_MDC,
	MX53_PAD_FEC_MDIO__FEC_MDIO,
	MX53_PAD_FEC_REF_CLK__FEC_TX_CLK,
	MX53_PAD_FEC_RX_ER__FEC_RX_ER,
	MX53_PAD_FEC_CRS_DV__FEC_RX_DV,
	MX53_PAD_FEC_RXD1__FEC_RDATA_1,
	MX53_PAD_FEC_RXD0__FEC_RDATA_0,
	MX53_PAD_FEC_TX_EN__FEC_TX_EN,
	MX53_PAD_FEC_TXD1__FEC_TDATA_1,
	MX53_PAD_FEC_TXD0__FEC_TDATA_0,
	MX53_PAD_PATA_DA_0__GPIO7_6,	/* FEC_nRST */
	MX53_PAD_PATA_DATA4__GPIO2_4,	/* FEC_nINT */ //on 900 is USB_OTG_PWR_EN


	/* I2C1 */
	MX53_PAD_CSI0_DAT8__I2C1_SDA,
	MX53_PAD_CSI0_DAT9__I2C1_SCL,
	/* I2C2 */
	MX53_PAD_KEY_COL3__I2C2_SCL,
	MX53_PAD_KEY_ROW3__I2C2_SDA,
	/* I2C3 */
	MX53_PAD_GPIO_3__I2C3_SCL,
	MX53_PAD_GPIO_6__I2C3_SDA,

	/* SD1 */
	MX53_PAD_SD1_CMD__ESDHC1_CMD,
	MX53_PAD_SD1_CLK__ESDHC1_CLK,
	MX53_PAD_SD1_DATA0__ESDHC1_DAT0,
	MX53_PAD_SD1_DATA1__ESDHC1_DAT1,
	MX53_PAD_SD1_DATA2__ESDHC1_DAT2,
	MX53_PAD_SD1_DATA3__ESDHC1_DAT3,

	//TODO: not UART on 900, overwritten in 900 specific
	/* UART1 */
	MX53_PAD_CSI0_DAT10__UART1_TXD_MUX,
	MX53_PAD_CSI0_DAT11__UART1_RXD_MUX,

	/* PWM */
	MX53_PAD_GPIO_1__PWM2_PWMO,  //DISP0_CONTRAST ; LCD_PWM_3V3

	// PMIC
	MX53_PAD_GPIO_5__GPIO1_5,		// NVDD_FAULT
	MX53_PAD_GPIO_8__GPIO1_8,		// MX53_NONKEY
	MX53_PAD_GPIO_16__GPIO7_11,		// NIRQ

	/* product information */
	MX53_PAD_NANDF_CLE__GPIO6_7, 	//PROD_ID0
	MX53_PAD_NANDF_ALE__GPIO6_8, 	//PROD_ID1
	MX53_PAD_NANDF_WP_B__GPIO6_9,	//PROD_ID2
	MX53_PAD_NANDF_RB0__GPIO6_10, 	//PROD_ID3
	MX53_PAD_NANDF_RE_B__GPIO6_13, 	//PROD_REV0
	MX53_PAD_NANDF_CS1__GPIO6_14, 	//PROD_REV1
	MX53_PAD_NANDF_CS2__GPIO6_15, 	//PROD_REV2
	MX53_PAD_NANDF_CS3__GPIO6_16, 	//PROD_REV3

	/* touchscreen */
	MX53_PAD_EIM_DA3__GPIO3_3,		//CAP_TS_RST_N
	MX53_PAD_EIM_DA4__GPIO3_4,		//CAP_TS_INT_N

	MX53_PAD_EIM_D27__GPIO3_27,  //ACT_STBY

	/* audio */
	MX53_PAD_GPIO_0__CCM_SSI_EXT1_CLK,	// Audio CLK
	MX53_PAD_KEY_COL0__AUDMUX_AUD5_TXC, //I2S_SCLK
	MX53_PAD_KEY_ROW0__AUDMUX_AUD5_TXD, //I2S_DOUT
	MX53_PAD_KEY_COL1__AUDMUX_AUD5_TXFS,//I2S_LRCLK
	MX53_PAD_KEY_ROW1__AUDMUX_AUD5_RXD, //I2S_DIN

#ifndef DEBUG_AMP
	MX53_PAD_PATA_DIOR__GPIO7_3,  	//AMP_SD_N
#endif
};

/**
 * Display specific pads.
 */
#define MX53_LVDS0_PADS \
	MX53_PAD_LVDS0_TX3_P__LDB_LVDS0_TX3, \
	MX53_PAD_LVDS0_CLK_P__LDB_LVDS0_CLK, \
	MX53_PAD_LVDS0_TX2_P__LDB_LVDS0_TX2, \
	MX53_PAD_LVDS0_TX1_P__LDB_LVDS0_TX1, \
	MX53_PAD_LVDS0_TX0_P__LDB_LVDS0_TX0

#define MX53_LVDS1_PADS \
	MX53_PAD_LVDS1_TX3_P__LDB_LVDS1_TX3, \
	MX53_PAD_LVDS1_TX2_P__LDB_LVDS1_TX2, \
	MX53_PAD_LVDS1_CLK_P__LDB_LVDS1_CLK, \
	MX53_PAD_LVDS1_TX1_P__LDB_LVDS1_TX1, \
	MX53_PAD_LVDS1_TX0_P__LDB_LVDS1_TX0

#define MX53_VGA_18BIT_PADS \
	MX53_PAD_DI0_DISP_CLK__IPU_DI0_DISP_CLK, \
	MX53_PAD_DISP0_DAT0__IPU_DISP0_DAT_0, \
	MX53_PAD_DISP0_DAT1__IPU_DISP0_DAT_1, \
	MX53_PAD_DISP0_DAT2__IPU_DISP0_DAT_2, \
	MX53_PAD_DISP0_DAT3__IPU_DISP0_DAT_3, \
	MX53_PAD_DISP0_DAT4__IPU_DISP0_DAT_4, \
	MX53_PAD_DISP0_DAT5__IPU_DISP0_DAT_5, \
	MX53_PAD_DISP0_DAT6__IPU_DISP0_DAT_6, \
	MX53_PAD_DISP0_DAT7__IPU_DISP0_DAT_7, \
	MX53_PAD_DISP0_DAT8__IPU_DISP0_DAT_8, \
	MX53_PAD_DISP0_DAT9__IPU_DISP0_DAT_9, \
	MX53_PAD_DISP0_DAT10__IPU_DISP0_DAT_10, \
	MX53_PAD_DISP0_DAT11__IPU_DISP0_DAT_11, \
	MX53_PAD_DISP0_DAT12__IPU_DISP0_DAT_12, \
	MX53_PAD_DISP0_DAT13__IPU_DISP0_DAT_13, \
	MX53_PAD_DISP0_DAT14__IPU_DISP0_DAT_14, \
	MX53_PAD_DISP0_DAT15__IPU_DISP0_DAT_15, \
	MX53_PAD_DISP0_DAT16__IPU_DISP0_DAT_16, \
	MX53_PAD_DISP0_DAT17__IPU_DISP0_DAT_17

#define MX53_VGA_24BIT_PADS \
	MX53_VGA_18BIT_PADS, \
	MX53_PAD_DISP0_DAT18__IPU_DISP0_DAT_18, \
	MX53_PAD_DISP0_DAT19__IPU_DISP0_DAT_19, \
	MX53_PAD_DISP0_DAT20__IPU_DISP0_DAT_20, \
	MX53_PAD_DISP0_DAT21__IPU_DISP0_DAT_21, \
	MX53_PAD_DISP0_DAT22__IPU_DISP0_DAT_22, \
	MX53_PAD_DISP0_DAT23__IPU_DISP0_DAT_23

// Wifi
#define MX53_WIFI_PADS \
	MX53_PAD_EIM_DA5__GPIO3_5,      		/* WIFI_ON */ \
	MX53_PAD_PATA_DATA8__ESDHC3_DAT0,		/* SD3_DATA0 */ \
	MX53_PAD_PATA_DATA9__ESDHC3_DAT1,		/* SD3_DATA1 */ \
	MX53_PAD_PATA_DATA10__ESDHC3_DAT2,		/* SD3_DATA2 */ \
	MX53_PAD_PATA_DATA11__ESDHC3_DAT3,		/* SD3_DATA3 */ \
	MX53_PAD_PATA_IORDY__ESDHC3_CLK,		/* SD3_CLK */ \
	MX53_PAD_PATA_RESET_B__ESDHC3_CMD,		/* SD3_CMD */ \
	MX53_PAD_EIM_DA11__GPIO3_11,			/* SD3_CD */ \
	MX53_PAD_EIM_DA12__GPIO3_12,			/* SD3_WP */ \
	MX53_PAD_PATA_DA_1__GPIO7_7				/* SD3_INT */ \

//HPRF
#define MX53_HPRF_PADS \
	MX53_PAD_EIM_D16__ECSPI1_SCLK,\
	MX53_PAD_EIM_D17__ECSPI1_MISO,\
	MX53_PAD_EIM_D18__ECSPI1_MOSI,\
	MX53_PAD_EIM_D19__ECSPI1_SS1,\
	MX53_PAD_PATA_DATA0__GPIO2_0, 			/* test point */ \
	MX53_PAD_PATA_DATA1__GPIO2_1,			/* RF_RXTX_EN */ \
	MX53_PAD_PATA_DATA2__GPIO2_2,			/* RF_ATTN_N */ \
	MX53_PAD_PATA_DATA3__GPIO2_3,			/* RF_RXEN */ \
	MX53_PAD_PATA_DATA5__GPIO2_5,			/* RF_TXEN */ \
	MX53_PAD_PATA_DATA6__GPIO2_6,			/* RF_RESET_N */ \
	MX53_PAD_PATA_DATA7__GPIO2_7,   		/* HP_RF_ON */ \
	MX53_PAD_PATA_DATA12__GPIO2_12, 		/* RF_ID2 */ \
	MX53_PAD_PATA_DATA13__GPIO2_13, 		/* RF_ID1 */ \
	MX53_PAD_PATA_DATA14__GPIO2_14,			/* RF_ID0 */ \
	MX53_PAD_PATA_DATA15__GPIO2_15			/* RF_INT_N */ \
/**
 * Board specific pads.
 */
static iomux_v3_cfg_t mx53_tsw550_pads[] = {
    // Display stuff
	MX53_VGA_24BIT_PADS,
	MX53_PAD_SD2_DATA1__GPIO1_14,			// DISP1_POWER_3V3
	MX53_PAD_SD2_DATA2__GPIO1_13,			// DISP1_BLKT_EN_3V3
	MX53_PAD_SD2_DATA3__GPIO1_12,			// DSPL_BUF_EN_3V3_N
	MX53_PAD_DI0_PIN2__IPU_DI0_PIN2,		// DISP1_HSYNC_2V775
	MX53_PAD_DI0_PIN3__IPU_DI0_PIN3,		// DISP1_VSYNC_2V775
	MX53_PAD_DI0_PIN4__GPIO4_20,			// DISP1_STANDBY_N
	MX53_PAD_DI0_PIN15__IPU_DI0_PIN15, 		// DISP1_DRDY_2V775
	MX53_PAD_EIM_DA14__CCM_DI0_EXT_CLK,

	// LEDs
	MX53_PAD_PATA_DATA7__GPIO2_7,   		// LEDS_RST_3V3

    // Audio
	MX53_PAD_PATA_DATA13__GPIO2_13, 		// MIC_SEL_3V3
	MX53_PAD_PATA_DATA12__GPIO2_12, 		// VLED_EN_3V3
	MX53_PAD_PATA_DATA10__GPIO2_10,  		//CODEC_RST_3V3_N
};

static iomux_v3_cfg_t mx53_tst600_pads[] = {
	/* POWER */
	MX53_PAD_EIM_EB2__GPIO2_30,				// EXT_PWR_N
	MX53_PAD_PATA_DIOW__GPIO6_17,			// POWER_5V_ON
	MX53_PAD_PATA_DMACK__GPIO6_18,			// POWER_12V_ON
	MX53_PAD_GPIO_2__GPIO1_2,				// FEC_PWR_ON
	/* battery */
	MX53_PAD_EIM_D25__GPIO3_25,				// GG_PROG_PULSE

	// SD3 - Wifi
	MX53_WIFI_PADS,

	// HPRF
	MX53_HPRF_PADS,

	// Display
	MX53_VGA_18BIT_PADS,
	MX53_PAD_SD2_DATA0__GPIO1_15,           // LCD_V_FLIP
	MX53_PAD_SD2_DATA1__GPIO1_14,           // LCD_H_FLIP
	MX53_PAD_SD2_DATA2__GPIO1_13,           // LCD_BK_PWR_EN
	MX53_PAD_SD2_DATA3__GPIO1_12,           // DSPL_BUF_EN_N
	MX53_PAD_EIM_D24__GPIO3_24,				// DISP0_POWER_EN
	MX53_PAD_PATA_INTRQ__GPIO7_2,			// LCD_BLT_EN
	MX53_PAD_EIM_D28__GPIO3_28,  			// BKLIGHT_CTRL
	MX53_PAD_DI0_PIN15__IPU_DI0_PIN15,		// DISP0_DRDY
	MX53_PAD_EIM_DA14__CCM_DI0_EXT_CLK,

	// Audio
	MX53_PAD_PATA_CS_0__GPIO7_9,  			// CODEC_INT_OUT
	MX53_PAD_PATA_DA_2__GPIO7_8,    		// CODEC_RESET_N

	/* IR */
	MX53_PAD_EIM_D31__GPIO3_31, 			// IR_PWR_CTRL
	MX53_PAD_EIM_DA9__GPIO3_9,				// IR_IRQ_N
	MX53_PAD_EIM_DA10__GPIO3_10,			// IR_RST_N

	/* tst600 50MHZ osc */
	MX53_PAD_PATA_DMARQ__GPIO7_0,    		// MHZ_50_OSC_EN

	// Boot Config
	MX53_PAD_EIM_LBA__GPIO2_27,				// BOOT_CFG1_0
	MX53_PAD_EIM_A16__GPIO2_22,				// BOOT_CFG1_1
	MX53_PAD_EIM_A18__GPIO2_20,				// BOOT_CFG1_3
	MX53_PAD_EIM_A19__GPIO2_19,				// BOOT_CFG1_4
	MX53_PAD_EIM_A20__GPIO2_18,				// BOOT_CFG1_5
	MX53_PAD_EIM_A21__GPIO2_17,				// BOOT_CFG1_6
	MX53_PAD_EIM_A22__GPIO2_16,				// BOOT_CFG1_7
	MX53_PAD_EIM_DA2__GPIO3_2,				// BOOT_CFG2_3
	MX53_PAD_EIM_DA1__GPIO3_1,				// BOOT_CFG2_4
	MX53_PAD_EIM_DA0__GPIO3_0,				// BOOT_CFG2_5
	MX53_PAD_EIM_EB1__GPIO2_29,				// BOOT_CFG2_6
	MX53_PAD_EIM_EB0__GPIO2_28,				// BOOT_CFG2_7
	MX53_PAD_EIM_DA8__GPIO3_8,				// BOOT_CFG3_3
	MX53_PAD_EIM_DA7__GPIO3_7,				// BOOT_CFG3_4
	MX53_PAD_EIM_DA6__GPIO3_6,				// BOOT_CFG3_5

	// Key-switch
	MX53_PAD_EIM_DA15__GPIO3_15, 			// KEY_INT_N
};

static iomux_v3_cfg_t mx53_tst900_pads[] = {
	/* POWER */
	MX53_PAD_EIM_EB2__GPIO2_30,				// EXT_PWR_N

	// SD3 - Wifi
	MX53_WIFI_PADS,

	//RF gpios
	MX53_HPRF_PADS,

	// Finger Nav
	MX53_PAD_EIM_OE__ECSPI2_MISO,			// ECSPI_2_MISO
	MX53_PAD_EIM_RW__GPIO2_26,				// ECSPI_2_CS0 //purposely use as gpio
	MX53_PAD_EIM_LBA__GPIO2_27,				// ECSPI_2_CS1 //purposely use as gpio
	MX53_PAD_EIM_D20__GPIO3_20,				// FN1_GPIO
	MX53_PAD_EIM_D21__GPIO3_21,				// FN2_GPIO
	MX53_PAD_EIM_D22__GPIO3_22,				// FN1_DM_SW+
	MX53_PAD_EIM_D23__GPIO3_23,				// FN2_DM_SW+
	MX53_PAD_EIM_D28__GPIO3_28,				// FN1_MOTION_N
	MX53_PAD_EIM_D30__GPIO3_30,				// FN2_MOTION_N
	MX53_PAD_DISP0_DAT0__GPIO4_21,			// FNX_RST_N
	MX53_PAD_DISP0_DAT1__GPIO4_22,			// FNX_SHUTDOWN

	// Display stuff
	MX53_LVDS0_PADS,
	MX53_PAD_EIM_D24__GPIO3_24,				//DISP0_POWER_EN
	MX53_PAD_EIM_D31__GPIO3_31,				// LCD_REV_SCAN
	MX53_PAD_PATA_INTRQ__GPIO7_2,			// BACKLT_SHDN_N

	// Audio
	MX53_PAD_PATA_CS_0__GPIO7_9,  			// CODEC_INT_OUT
	MX53_PAD_PATA_DA_2__GPIO7_8,    		// CODEC_RESET_N
	MX53_PAD_EIM_D25__GPIO3_25,				// HP_N

	// Camera
	MX53_PAD_CSI0_DAT10__IPU_CSI0_D_10,
	MX53_PAD_CSI0_DAT11__IPU_CSI0_D_11,
	MX53_PAD_CSI0_DAT12__IPU_CSI0_D_12,
	MX53_PAD_CSI0_DAT13__IPU_CSI0_D_13,
	MX53_PAD_CSI0_DAT14__IPU_CSI0_D_14,
	MX53_PAD_CSI0_DAT15__IPU_CSI0_D_15,
	MX53_PAD_CSI0_DAT16__IPU_CSI0_D_16,
	MX53_PAD_CSI0_DAT17__IPU_CSI0_D_17,
	MX53_PAD_CSI0_DAT18__IPU_CSI0_D_18,
	MX53_PAD_CSI0_DAT19__IPU_CSI0_D_19,
	MX53_PAD_CSI0_VSYNC__IPU_CSI0_VSYNC,
	MX53_PAD_CSI0_MCLK__IPU_CSI0_HSYNC,
	MX53_PAD_CSI0_PIXCLK__IPU_CSI0_PIXCLK,
	MX53_PAD_EIM_EB1__IPU_CSI1_D_10,
	MX53_PAD_EIM_EB0__IPU_CSI1_D_11,
	MX53_PAD_EIM_A17__IPU_CSI1_D_12,
	MX53_PAD_EIM_A18__IPU_CSI1_D_13,
	MX53_PAD_EIM_A19__IPU_CSI1_D_14,
	MX53_PAD_EIM_A20__IPU_CSI1_D_15,
	MX53_PAD_EIM_A21__IPU_CSI1_D_16,
	MX53_PAD_EIM_A22__IPU_CSI1_D_17,
	MX53_PAD_EIM_A23__IPU_CSI1_D_18,
	MX53_PAD_EIM_A24__IPU_CSI1_D_19,
	MX53_PAD_EIM_D29__IPU_CSI1_VSYNC,
	MX53_PAD_EIM_EB3__IPU_CSI1_HSYNC,
	MX53_PAD_EIM_A16__IPU_CSI1_PIXCLK,
	MX53_PAD_EIM_WAIT__GPIO5_0,				// CAM_DAT_N
	MX53_PAD_EIM_D27__GPIO3_27,				// CAM_PWR_EN
	MX53_PAD_DI0_PIN2__GPIO4_18,			// CAMERA_RST_N
	MX53_PAD_DI0_PIN3__GPIO4_19,			// CAMERA_1_PWDN
	MX53_PAD_DI0_PIN4__GPIO4_20,			// CAMERA_2_PWDN

	// TODO: SD2 - IRD?
	MX53_PAD_SD2_DATA0__ESDHC2_DAT0,
	MX53_PAD_SD2_DATA1__ESDHC2_DAT1,
	MX53_PAD_SD2_DATA2__ESDHC2_DAT2,
	MX53_PAD_SD2_DATA3__ESDHC2_DAT3,
	MX53_PAD_SD2_CLK__ESDHC2_CLK,
	MX53_PAD_SD2_CMD__ESDHC2_CMD,
	MX53_PAD_EIM_DA10__GPIO3_10,			// SD2_CD
	MX53_PAD_EIM_DA14__GPIO3_14,			// SD2_OC_N
	MX53_PAD_EIM_DA15__GPIO3_15,			// SD2_PWR_N

	// USB
	MX53_PAD_EIM_DA9__GPIO3_9,				// USB_OTG_OC
	MX53_PAD_PATA_DATA4__GPIO2_4,			// USB_OTG_PWR_EN

	// UART
	MX53_PAD_PATA_DIOW__UART1_TXD_MUX,
	MX53_PAD_PATA_DMACK__UART1_RXD_MUX,
};

static iomux_v3_cfg_t mx53_tsw750_pads[] = {
    // Display stuff
	MX53_VGA_18BIT_PADS,
	MX53_PAD_SD2_DATA1__GPIO1_14,             //DISP1_POWER_3V3
	MX53_PAD_SD2_DATA2__GPIO1_13,             //DISP1_BLKT_EN_3V3
	//MX53_PAD_PATA_CS_1__PATA_CS_1,				//VLED_SIG_EN
	MX53_PAD_PATA_CS_1__GPIO7_10,				//VLED_SIG_EN

	MX53_PAD_DI0_PIN15__IPU_DI0_PIN15, // DISP1_DRDY_2V775


    // DMM 750
	MX53_PAD_DI0_PIN2__IPU_DI0_PIN2,
	MX53_PAD_DI0_PIN3__IPU_DI0_PIN3,
	MX53_PAD_DISP0_DAT21__GPIO5_15, // LCD_BUFF_EN
	MX53_PAD_DISP0_DAT22__GPIO5_16, // DISP1_RL_2V775
	MX53_PAD_DISP0_DAT23__GPIO5_17, // DISP1_UD_2V775

	MX53_PAD_EIM_DA14__CCM_DI0_EXT_CLK,

	MX53_PAD_PATA_DATA7__GPIO2_7,   // LEDS_RST_3V3
    // Audio
	MX53_PAD_PATA_DATA13__GPIO2_13, // MIC_SEL_3V3
	MX53_PAD_PATA_DATA12__GPIO2_12, // VLED_EN_3V3
	MX53_PAD_PATA_DATA10__GPIO2_10,  //CODEC_RST_3V3_N
};

static iomux_v3_cfg_t mx53_tsw1050_pads[] = {
	/* LVDS */
	MX53_LVDS0_PADS,
#ifndef NO_1050_LCD //RJK to access pins manually from command line
	MX53_PAD_SD2_DATA1__GPIO1_14,             //DISP1_POWER_3V3
	MX53_PAD_SD2_DATA2__GPIO1_13,             //LCD_BK_PWR_EN
	MX53_PAD_DISP0_DAT21__GPIO5_15,				//LCD_BUFF_EN
	//MX53_PAD_PAT_ACS_1__PATA_CS_1,				//VLED_SIG_EN
	MX53_PAD_PATA_CS_1__GPIO7_10,				//VLED_SIG_EN
	MX53_PAD_PATA_DATA12__GPIO2_12,				//VLED_EN_3V3
#endif

	MX53_PAD_EIM_DA14__CCM_DI0_EXT_CLK,

	MX53_PAD_PATA_DATA7__GPIO2_7,   // LEDS_RST_3V3
	// Audio
	MX53_PAD_PATA_DATA13__GPIO2_13, // MIC_SEL_3V3
	MX53_PAD_PATA_DATA10__GPIO2_10,  //CODEC_RST_3V3_N
	MX53_PAD_DI0_PIN15__IPU_DI0_PIN15,
};


static void loco_da9053_irq_wakeup_only_fixup(void)
{
	void __iomem *tzic_base;
	tzic_base = ioremap(MX53_TZIC_BASE_ADDR, SZ_4K);
	if (NULL == tzic_base) {
		pr_err("fail to map MX53_TZIC_BASE_ADDR\n");
		return;
	}
	__raw_writel(0, tzic_base + TZIC_WAKEUP0_OFFSET);
	__raw_writel(0, tzic_base + TZIC_WAKEUP1_OFFSET);
	__raw_writel(0, tzic_base + TZIC_WAKEUP2_OFFSET);
	/* only enable irq wakeup for da9053 */
	__raw_writel(GPIO7_0_11_IRQ_BIT, tzic_base + TZIC_WAKEUP3_OFFSET);
	iounmap(tzic_base);
	pr_info("only da9053 irq is wakeup-enabled\n");
}
//RJK suspend come through functions below...
static void loco_suspend_enter(void)
{

//printk(KERN_ERR "RJK:: suspend enter\n");
	if (!board_is_mx53_loco_mc34708()) {
		loco_da9053_irq_wakeup_only_fixup();
		da9053_suspend_cmd_sw();
	}
}

static void loco_suspend_exit(void)
{
//printk(KERN_ERR "RJK:: suspend exit\n");
	if (!board_is_mx53_loco_mc34708()) {
		if (da9053_get_chip_version())
			da9053_restore_volt_settings();
	}
}

static struct mxc_pm_platform_data loco_pm_data = {
	.suspend_enter = loco_suspend_enter,
	.suspend_exit = loco_suspend_exit,
};

/*  Reference only: field definitions of video_mode struct
struct fb_videomode {
        const char *name; refresh; xres; yres; pixclock; left_margin; right_margin; upper_margin; lower_margin;
        hsync_len; vsync_len; 
	sync;
        vmode;
        flag;
};
*/

static struct fb_videomode video_modes[] = {
        {
         /* 800x480 @ 57 Hz , pixel clk @ 27MHz */
         "CLAA-WVGA", 57, 800, 480, 37037, 40, 60, 10, 10, 20, 10,
        FB_SYNC_CLK_LAT_FALL,
        FB_VMODE_NONINTERLACED,
        0,},
        {
	 /* 640x480 @ 57 Hz , pixel clk @ 27MHz */
	 "TST600-WVGA", 60, 640, 480, 25200, 40, 60, 10, 10, 20, 10,
	FB_SYNC_CLK_LAT_FALL,
	FB_VMODE_NONINTERLACED,
	 0,},
/* for LVDS cwcontent below is defined in the /drivers/video/mxc/ldb.c driver file.
        {
	 // 1280x800 @ 60 Hz , 71M pixel clk ioutput @ 27MHz 
	 // params from WinCE 1050 driver 
	 //  14063 = 1/71000000
	 "TSW1050-WXGA", 60, 1280, 800, 14063, 48, 80, 3, 14, 32, 6,
	0,
	FB_VMODE_NONINTERLACED,
	 0,},
*/
    {
        // DMM
        /* 800x480 @ 60 Hz, */
        /* Invert pixel clock rate. */
        /* 1 / ((800 + 88 + 40 + 128) * (480 + 33 + 10 + 2) * 60) */
        "TSW750-WVGA", 60, 800, 480, 30062, 88, 40, 33, 10, 128, 2,
        FB_SYNC_CLK_LAT_FALL,
        FB_VMODE_NONINTERLACED,
        0,
    },
    {
		// RT
		/* 800x480 @ 60 Hz, */
		/* Invert pixel clock rate. */
		/* 1 / ((800 + 88 + 40 + 128) * (480 + 33 + 10 + 2) * 60) */
		"TSW550-WVGA", 60, 800, 480, 30062, 88, 40, 33, 10, 128, 2,
		FB_SYNC_CLK_LAT_FALL,
		FB_VMODE_NONINTERLACED,
		0,
	},

	{
         /* 800x480 @ 60 Hz , pixel clk @ 32MHz */
         "SEIKO-WVGA", 60, 800, 480, 29850, 89, 164, 23, 10, 10, 10,
         FB_SYNC_CLK_LAT_FALL,
         FB_VMODE_NONINTERLACED,
         0,},
        {
         "XGA", 60, 1024, 768, 15385,
         220, 40,
         21, 7,
         60, 10,
         0,
         FB_VMODE_NONINTERLACED,
         0,},
	{
        /* VGA 1280x1024 108M pixel clk output */
        "SXGA", 60, 1280, 1024, 9259,
        48, 248,
        1, 38,
        112, 3,
        0,
        FB_VMODE_NONINTERLACED,
        0,},
	 {
        /* 1600x1200 @ 60 Hz 162M pixel clk*/
        "UXGA", 60, 1600, 1200, 6172,
        304, 64,
        1, 46,
        192, 3,
        FB_SYNC_HOR_HIGH_ACT|FB_SYNC_VERT_HIGH_ACT,
        FB_VMODE_NONINTERLACED,
        0,},

};

static struct platform_pwm_backlight_data mxc_pwm_backlight_data = {
	.pwm_id = 1,
	.max_brightness = 255,
	.invert_brightness = true,
	.dft_brightness = 63,    // Crestron UIHal uses 0 - 100% values 63=~25%
	/* NOTE - ADENEO: this value is suitable for the SEIKO LCD.
	   It needs to be adapted for different panels */
	.pwm_period_ns = 50000, //RJK 20KHz
};

extern void mx5_ipu_reset(void);
static struct mxc_ipu_config mxc_ipu_data = {
	.rev = 3,
	.reset = mx5_ipu_reset,
};

extern void mx5_vpu_reset(void);
static struct mxc_vpu_platform_data mxc_vpu_data = {
	.iram_enable = true,
	.iram_size = 0x14000,
	.reset = mx5_vpu_reset,
};

static struct fec_platform_data fec_data = {
	.phy = PHY_INTERFACE_MODE_RMII,
};

static struct mxc_dvfs_platform_data dvfs_core_data = {
	.clk1_id = "cpu_clk",
	.clk2_id = "gpc_dvfs_clk",
	.gpc_cntr_offset = MXC_GPC_CNTR_OFFSET,
	.gpc_vcr_offset = MXC_GPC_VCR_OFFSET,
	.ccm_cdcr_offset = MXC_CCM_CDCR_OFFSET,
	.ccm_cacrr_offset = MXC_CCM_CACRR_OFFSET,
	.ccm_cdhipr_offset = MXC_CCM_CDHIPR_OFFSET,
	.prediv_mask = 0x1F800,
	.prediv_offset = 11,
	.prediv_val = 3,
	.div3ck_mask = 0xE0000000,
	.div3ck_offset = 29,
	.div3ck_val = 2,
	.emac_val = 0x08,
	.upthr_val = 25,
	.dnthr_val = 9,
	.pncthr_val = 33,
	.upcnt_val = 10,
	.dncnt_val = 10,
	.delay_time = 30,
};

static struct mxc_bus_freq_platform_data bus_freq_data;

static struct tve_platform_data tve_data = {
	.boot_enable = MXC_TVE_VGA,
};

static struct ldb_platform_data ldb_data = {
	.ext_ref = 1,
};

static void mxc_iim_enable_fuse(void)
{
	u32 reg;

	if (!ccm_base)
		return;

	/* enable fuse blown */
	reg = readl(ccm_base + 0x64);
	reg |= 0x10;
	writel(reg, ccm_base + 0x64);
}

static void mxc_iim_disable_fuse(void)
{
	u32 reg;

	if (!ccm_base)
		return;
	/* enable fuse blown */
	reg = readl(ccm_base + 0x64);
	reg &= ~0x10;
	writel(reg, ccm_base + 0x64);
}

static struct mxc_iim_data iim_data = {
	.bank_start = MXC_IIM_MX53_BANK_START_ADDR,
	.bank_end   = MXC_IIM_MX53_BANK_END_ADDR,
	.enable_fuse = mxc_iim_enable_fuse,
	.disable_fuse = mxc_iim_disable_fuse,
};

static struct resource mxcfb_resources[] = {
	[0] = {
	       .flags = IORESOURCE_MEM,
	       },
};

static struct mxc_fb_platform_data fb_data[] = {
	{
	//RJK addded
	 .interface_pix_fmt = IPU_PIX_FMT_RGB565,
	 .mode_str = "CLAA-WVGA",
	 .mode = video_modes,
	 .num_modes = ARRAY_SIZE(video_modes),
	 },
	{
	//RJK addded
	 .interface_pix_fmt = IPU_PIX_FMT_RGB666,
	 .mode_str = "TST600-WVGA",
	 .mode = video_modes,
	 .num_modes = ARRAY_SIZE(video_modes),
	 },
	{
	//RJK addded
	 .interface_pix_fmt = IPU_PIX_FMT_RGB666,
	 .mode_str = "TSW1050-WVGA",
	 .mode = video_modes,
	 .num_modes = ARRAY_SIZE(video_modes),
	 },
	{
	  //DMM added - DISPLAY parameters
	  .interface_pix_fmt = IPU_PIX_FMT_RGB666,
	  .mode_str = "TSW750-WVGA",
	  .mode = video_modes,
	  .num_modes = ARRAY_SIZE(video_modes),
	},
	{
	  //RT added - DISPLAY parameters
	  .interface_pix_fmt = IPU_PIX_FMT_RGB24,
	  .mode_str = "TSW550-WVGA",
	  .mode = video_modes,
	  .num_modes = ARRAY_SIZE(video_modes),
	},
	{
	 .interface_pix_fmt = IPU_PIX_FMT_RGB24,
	 .mode_str = "SEIKO-WVGA",
	 .mode = video_modes,
	 .num_modes = ARRAY_SIZE(video_modes),
	 },
	{
	 .interface_pix_fmt = IPU_PIX_FMT_GBR24,
	 .mode_str = "SXGA",
	 .mode = video_modes,
	 .num_modes = ARRAY_SIZE(video_modes),
	 },
};

extern int primary_di;
static int __init mxc_init_fb(void)
{
    int fb_data_index = 1;
	if (!machine_is_mx53_loco())
		return 0;

	printk(KERN_ERR "######################### LCD_PROBE #####################\n");

	/*for loco board, set default display as VGA*/
	if (primary_di < 0)
		primary_di = 1;

	switch(gProductId) {
	case TST600: fb_data_index = 1; break;
	case TSW750: fb_data_index = 3; break;
	case TSW1050:fb_data_index = 2; break;
	case TSW550: fb_data_index = 4; break;
	default:
		fb_data_index = 1;
		break;
	}
	//printk(KERN_INFO "DMM gProductId=%x fb_data_index=%i\n", gProductId, fb_data_index);
	if (primary_di) {
		printk(KERN_INFO "DI1 is primary\n");
		/* DI1 -> DP-BG channel: */
		mxc_fb_devices[1].num_resources = ARRAY_SIZE(mxcfb_resources);
		mxc_fb_devices[1].resource = mxcfb_resources;
		mxc_register_device(&mxc_fb_devices[1], &fb_data[fb_data_index]);

		/* DI0 -> DC channel: */
		mxc_register_device(&mxc_fb_devices[0], &fb_data[0]);
	} else {
		printk(KERN_INFO "DI0 is primary\n");

		/* DI0 -> DP-BG channel: */
		mxc_fb_devices[0].num_resources = ARRAY_SIZE(mxcfb_resources);
		mxc_fb_devices[0].resource = mxcfb_resources;
		//mxc_register_device(&mxc_fb_devices[0], &fb_data[0]);
		mxc_register_device(&mxc_fb_devices[0], &fb_data[fb_data_index]);

		/* DI1 -> DC channel: */
        // *Not* safe to register device 1 with NULL.
		//mxc_register_device(&mxc_fb_devices[1], &fb_data[fb_data_index]);
		//mxc_register_device(&mxc_fb_devices[1], &fb_data[0]);
		//mxc_register_device(&mxc_fb_devices[1], NULL);
	}

	/*
	 * DI0/1 DP-FG channel:
	 */
	mxc_register_device(&mxc_fb_devices[2], NULL);

	return 0;
}
device_initcall(mxc_init_fb);

//RJK this will turn on the Hardware LED on the tst600
static void enableLED(void)
{
// 	gpio_direction_output(DOCK_CHG_INDICATOR, 0);
	gpio_set_value(DOCK_CHG_INDICATOR, 1);
	msleep(10);
}

//RJK this will turn off the Hardware LED on the tst600
static void disableLED(void)
{
        gpio_set_value(DOCK_CHG_INDICATOR, 0);
        msleep(10);
}

static void sii902x_hdmi_reset(void)
{
	gpio_set_value(DISP0_RESET, 0);
	msleep(10);
	gpio_set_value(DISP0_RESET, 1);
	msleep(10);
}

static int sii902x_get_pins(void)
{
	/* Sii902x HDMI controller */
	gpio_request(DISP0_RESET, "disp0-reset");
	gpio_direction_output(DISP0_RESET, 0);
	gpio_request(DISP0_DET_INT, "disp0-detect");
	gpio_direction_input(DISP0_DET_INT);
	return 1;
}

static void sii902x_put_pins(void)
{
	gpio_free(DISP0_RESET);
	gpio_free(DISP0_DET_INT);
}

/* platform data */
static struct mxc_lcd_platform_data sii902x_hdmi_data = {
	.reset = sii902x_hdmi_reset,
	.fb_id = "DISP3 BG",
	.get_pins = sii902x_get_pins,
	.put_pins = sii902x_put_pins,
};

//i2c bus bitrate, same for all i2c busses (1,2 and 3)
static struct imxi2c_platform_data mxci2c_0_data = {
       .bitrate = 100000,
};

//i2c bus bitrate, same for all i2c busses (1,2 and 3)
static struct imxi2c_platform_data mxci2c_1_data = {
       .bitrate = 400000,
};

//i2c bus bitrate, same for all i2c busses (1,2 and 3)
static struct imxi2c_platform_data mxci2c_2_data = {
       .bitrate = 100000,
};

static struct ds278x_platform_data ds2786_data = {
	.rsns = 1000,
};
static struct max7360_platform_data max7360_data = {
	.flags = 0,  //RJK holder for more initialization
};

static int ft5x06_ts_hw_status(void)
{
        return gpio_get_value(CAP_TS_INT_N);
}

/**
 * Touchscreen parameters
 */

/**
 * Keycodes. Array so that we have one place to change them for all panels.
 */
typedef enum {
	CREST_VIRT_KEY_1 = KEY_BACK,
	CREST_VIRT_KEY_2 = KEY_HOME,
	CREST_VIRT_KEY_3 = KEY_MENU,
	CREST_VIRT_KEY_4 = KEY_VOLUMEUP,
	CREST_VIRT_KEY_5 = KEY_VOLUMEDOWN
} ft5x06_keycode;

static struct ft5x06_platform_data ft5x06_ts_data_550 = {
    .maxx       =796,   //Pretend it's in hex
    .maxy       =476,
    .use_mt     =1, // enable multi-touch
    .use_trk_id =1,
    .use_gestures   =1,
    .flags      =0x0,  //0=nothing;1=flipData;2=flipX;4=flipY
    .reset_gpio  = CAP_TS_RST_N,
    .has_virt_btn = 1,
    .virt_btn_startx = 796,
    .virt_btn_radius = 50,
    .virt_btn = {
		{   .centery = 62,
			.keycode = CREST_VIRT_KEY_1, },
		{   .centery = 152,
			.keycode = CREST_VIRT_KEY_2, },
		{   .centery = 247,
			.keycode = CREST_VIRT_KEY_3, },
		{   .centery = 352,
			.keycode = CREST_VIRT_KEY_4, },
		{   .centery = 447,
			.keycode = CREST_VIRT_KEY_5, },
    }
};

static struct ft5x06_platform_data ft5x06_ts_data_600 = {
    .maxx     =0x580,  //1408
    .maxy       =0x400,  //1024
    .use_mt     =1, // enable multi-touch
    .use_trk_id =1,
    .use_gestures   =1,
    .flags      =0x0,  //0=nothing;1=flipData;2=flipX;4=flipY
    .reset_gpio  = CAP_TS_RST_N,
    .has_virt_btn = 0
};

static struct ft5x06_platform_data ft5x06_ts_data_900 = {
    .maxx     =0x580,  //1408
    .maxy       =0x400,  //1024
    .use_mt     =1, // enable multi-touch
    .use_trk_id =1,
    .use_gestures   =1,
    .flags      =0x0,  //0=nothing;1=flipData;2=flipX;4=flipY
    .reset_gpio  = CAP_TS_RST_N,
    .has_virt_btn = 0
};

static struct ft5x06_platform_data ft5x06_ts_data_750 = {
    // DMM
    .maxx       =1600,   //Pretend it's in hex
    .maxy       =0x400,  //1024
    .use_mt     =1, // enable multi-touch
    .use_trk_id =1,
    .use_gestures   =1,
    .flags      =0x0,  //0=nothing;1=flipData;2=flipX;4=flipY
    .reset_gpio  = CAP_TS_RST_N,
    .has_virt_btn = 1,
    .virt_btn_startx = 1600,
    .virt_btn_radius = 50,
    .virt_btn = {
        {   .centery = 77,
            .keycode = CREST_VIRT_KEY_1, },
        {   .centery = 300,
            .keycode = CREST_VIRT_KEY_2, },
        {   .centery = 521,
            .keycode = CREST_VIRT_KEY_3, },
        {   .centery = 732,
            .keycode = CREST_VIRT_KEY_4, },
        {   .centery = 964,
            .keycode = CREST_VIRT_KEY_5, },
    }
};

static struct ft5x06_platform_data ft5x06_ts_data_1050 = {
	.maxx		=0x800,  //2048
	.maxy		=0x800,  //2048
	.use_mt		=1, // enable multi-touch
	.use_trk_id	=1,
	.use_gestures	=1,
	.flags		=0x0,  //0=nothing;1=flipData;2=flipX;4=flipY
	.hw_status = ft5x06_ts_hw_status,
	.reset_gpio  = CAP_TS_RST_N,
    .has_virt_btn = 1,
    .virt_btn_startx = 2080,
    .virt_btn_radius = 100,
    .virt_btn = {
        {   .centery = 251,
            .keycode = CREST_VIRT_KEY_1, },
        {   .centery = 661,
            .keycode = CREST_VIRT_KEY_2, },
        {   .centery = 1027,
            .keycode = CREST_VIRT_KEY_3, },
        {   .centery = 1436,
            .keycode = CREST_VIRT_KEY_4, },
        {   .centery = 1799,
            .keycode = CREST_VIRT_KEY_5, },
    }
};

static struct i2c_board_info mxc_i2c0_550[] __initdata = {
};
static struct i2c_board_info mxc_i2c1_550[] __initdata = {
    {
        // tlv320aic3254 driver tsw550 audio
        .type = "tlv320aic32x4",
        .addr = 0x18,
//        .irq = gpio_to_irq(CODEC_INT_OUT),  //no interrupt on 550
    },
    {
		// pds driver - eeprom
		.type = "m24m01",
		.addr = 0x54,
	},
};
static struct i2c_board_info mxc_i2c2_550[] __initdata = {
    {
        //RJK TST600 touch screen
        .type = "ft5x06_ts",
        .addr = 0x38,
        .irq  = gpio_to_irq(CAP_TS_INT_N),
        .platform_data = &ft5x06_ts_data_550,
    }
};
static struct i2c_board_info mxc_i2c0_600[] __initdata = {
    {
        //battery Gas guage driver on tst600
        .type = "ds2786",
        .addr = 0x36,
        .platform_data = &ds2786_data,
    },
};
static struct i2c_board_info mxc_i2c1_600[] __initdata = {
    {
        // tlv320aic3254 driver tst600 audio
        .type = "tlv320aic32x4",
        .addr = 0x18,
        .irq = gpio_to_irq(CODEC_INT_OUT),
    },
    {
        // tst600 KeyPad
        .type = "max7360",
        .addr = 0x38,
        .irq = gpio_to_irq(KEY_INT_N),
        .platform_data = &max7360_data,
    },
    {
		// pds driver - eeprom
		.type = "m24m01",
		.addr = 0x54,
	},
};
static struct i2c_board_info mxc_i2c2_600[] __initdata = {
    {
        //RJK TST600 touch screen
        .type = "ft5x06_ts",
        .addr = 0x38,
        .irq  = gpio_to_irq(CAP_TS_INT_N),
        .platform_data = &ft5x06_ts_data_600,
    }
    //TODO: IR
};

static struct i2c_board_info mxc_i2c0_900[] __initdata = {
	//TODO: gas gauge
};
static struct i2c_board_info mxc_i2c1_900[] __initdata = {
    {
        // tlv320aic3254 driver tst900 audio
        .type = "tlv320aic32x4",
        .addr = 0x18,
        .irq = gpio_to_irq(CODEC_INT_OUT),
    },
    {
        // tst900 KeyPad
        .type = "max7360",
        .addr = 0x38,
        .irq = gpio_to_irq(KEY_INT_N),
        .platform_data = &max7360_data,
    },
    {
		// pds driver - eeprom
		.type = "m24m01",
		.addr = 0x54,
	},
    //TODO: Camera 1
};
static struct i2c_board_info mxc_i2c2_900[] __initdata = {
    {
        //RJK TST600 touch screen
        .type = "ft5x06_ts",
        .addr = 0x38,
        .irq  = gpio_to_irq(CAP_TS_INT_N),
        .platform_data = &ft5x06_ts_data_900,
    }
    //TODO: backlight i2c
    //TODO: light sensor i2c
    //TODO: Camera 2
};

static struct i2c_board_info mxc_i2c0_750[] __initdata = {
};
static struct i2c_board_info mxc_i2c1_750[] __initdata = {
    {
        // tlv320aic3254 driver tst750 audio
        .type = "tlv320aic32x4",
        .addr = 0x18,
//        .irq = gpio_to_irq(CODEC_INT_OUT),  //no interrupt on 750
    },
    {
		// pds driver - eeprom
		.type = "m24m01",
		.addr = 0x54,
	},
};
static struct i2c_board_info mxc_i2c2_750[] __initdata = {
    {
        //RJK TST600 touch screen
        .type = "ft5x06_ts",
        .addr = 0x38,
        .irq  = gpio_to_irq(CAP_TS_INT_N),
        .platform_data = &ft5x06_ts_data_750,
    }
};

static struct i2c_board_info mxc_i2c0_1050[] __initdata = {
};
static struct i2c_board_info mxc_i2c1_1050[] __initdata = {
    {
        // tlv320aic3254 driver tst1050 audio
        .type = "tlv320aic32x4",
        .addr = 0x18,
//        .irq = gpio_to_irq(CODEC_INT_OUT),  //no interrupt on 1050
    },
    {
		// pds driver - eeprom
		.type = "m24m01",
		.addr = 0x54,
	},
};
static struct i2c_board_info mxc_i2c2_1050[] __initdata = {
    {
	 .type = "ft5x06_ts",
	 .addr = 0x04,
	 .irq  = gpio_to_irq(CAP_TS_INT_N),
	 .platform_data = &ft5x06_ts_data_1050,
	},
};


static int sdhc_write_protect(struct device *dev)
{
	int ret = 0;

	if (to_platform_device(dev)->id == 2)
		ret = gpio_get_value(SD3_WP);

	return ret;
}

static unsigned int sdhc_get_card_det_status(struct device *dev)
{
	int ret = 0;

	if (to_platform_device(dev)->id == 2)
		ret = gpio_get_value(SD3_CD_N);

	return ret;
}

static struct mxc_mmc_platform_data mmc1_data = {
	.ocr_mask = MMC_VDD_27_28 | MMC_VDD_28_29 | MMC_VDD_29_30
		| MMC_VDD_31_32,
	.caps = MMC_CAP_4_BIT_DATA,
	.min_clk = 400000,
	.max_clk = 50000000,
	.card_inserted_state = 1,
	.clock_mmc = "esdhc_clk",
	.power_mmc = NULL,
};

//TODO: second sd interface for IR?
static struct mxc_mmc_platform_data mmc2_data = {
	.ocr_mask = MMC_VDD_27_28 | MMC_VDD_28_29 | MMC_VDD_29_30
		| MMC_VDD_31_32,
	.caps = MMC_CAP_4_BIT_DATA | MMC_CAP_8_BIT_DATA
		| MMC_CAP_DATA_DDR,
	.min_clk = 400000,
	.max_clk = 50000000,
	.card_inserted_state = 0,
	.clock_mmc = "esdhc_clk",
};

static struct mxc_mmc_platform_data mmc3_data = {
	.ocr_mask = MMC_VDD_27_28 | MMC_VDD_28_29 | MMC_VDD_29_30
		| MMC_VDD_31_32,
	.caps = MMC_CAP_4_BIT_DATA | MMC_CAP_8_BIT_DATA
		| MMC_CAP_DATA_DDR,
	.min_clk = 400000,
	.max_clk = 50000000,
	.card_inserted_state = 0,
	.status = sdhc_get_card_det_status,
	.wp_status = sdhc_write_protect,
	.clock_mmc = "esdhc_clk",
};

static int headphone_det_status(void)
{
	//return (gpio_get_value(HEADPHONE_DEC_B) == 0);
	return 0;
}
static int mxc_sgtl5000_init(void);
static struct mxc_audio_platform_data sgtl5000_data = {
	.ssi_num = 1,
	.src_port = 2,
	.ext_port = 5,
	.hp_irq = gpio_to_irq(HEADPHONE_DEC_B),
	.hp_status = headphone_det_status,
	.init = mxc_sgtl5000_init,
	.ext_ram_rx = 1,
};

/**
 * DMM:TODO: Fix the aic driver to take a value specifying the reset pin.
 * Structure should be passed to reset so that the correct pin is used.
 * Should also be used in board_init.
 */
static int mxc_aic32x4_init(void);
static int mxc_aic32x4_amp_enable(int enable);
static struct mxc_audio_platform_data aic32x4_data = {
	.ssi_num = 1,
	.src_port = 2, //RJK, this should be correct, I2S
	.ext_port = 5, //RJK, using AUDMUX port5 pg593 i.mx53 ref manual
	.hp_irq = gpio_to_irq(HEADPHONE_DEC_B),
	.hp_status = headphone_det_status,
	.amp_enable = mxc_aic32x4_amp_enable,
	.init = mxc_aic32x4_init,
	.ext_ram_rx = 1,
};
static int aic32x4_readAmpPwr(void)
{
        return gpio_get_value(AMP_SD_N);
}
static int aic32x4_enable_5V(void)
{
	if(gProductId == TST600)
        gpio_set_value(POWER_5V_ON, 1);
	return 0;
}

static int mxc_aic32x4_amp_enable(int enable)
{
	// 1=enable;  0=disable
	printk(KERN_ERR "Calling amp enable with : %d\n", enable);
	switch (enable) { 
	case 0:   //disable
#ifndef DEBUG_AMP
		gpio_set_value(AMP_SD_N, enable);
#endif
		break;
	case 1:   //enable
		msleep(10);
#ifndef DEBUG_AMP
		gpio_set_value(AMP_SD_N, !enable); 
#endif
		msleep(5);  //Hold low for at least 10 ns
#ifndef DEBUG_AMP
		gpio_set_value(AMP_SD_N, enable);
#endif
		msleep(5); //settle 
		break;
	}
	return 0;
}

static int mxc_aic32x4_reset(void)
{
	printk(KERN_ERR "Calling mxc_aic32x4_reset \n");
    int pin = CODEC_RESET_N;
    switch(gProductId) {
	case TSW1050:
	case TSW750:
	case TSW550:
    	pin = CODEC_RST_3V3_N;
    	break;

    case TST600:
    case TST900:
    default:
        pin = CODEC_RESET_N; break;
    }
	gpio_set_value(pin, 0); //RJK put into reset
	msleep(50);
	gpio_set_value(pin, 1); //RJK take out of reset
	msleep(50);
	return 0;
}

static int mxc_aic32x4_init(void)
{
	struct clk *ssi_ext1;
	struct clk *clk_parent;
	int rate;

    //printk(KERN_ERR "RJK:: in mxc_aic32x4_init\n");

	mxc_aic32x4_amp_enable(0);

	// 5V supply may already be on
	aic32x4_enable_5V();

	mxc_aic32x4_reset();

	clk_parent = clk_get(NULL, "ssi_lp_apm_clk");
	if (IS_ERR(clk_parent)){
		printk("Could not get clk parent -ssi_lp_apm_clk-\n");		
		return -1;
	}
	ssi_ext1 = clk_get(NULL, "ssi_ext1_clk");
	if (IS_ERR(ssi_ext1)){
		printk("Could not get audio clk -ssi_ext1_clk-\n");		
		return -1;
	}

	//RJK rate = clk_round_rate(ssi_ext1, 24000000);
	rate = 24000000; //RJK force this for now.
	//rate = 12000000; //RJK force this for now.
	if (rate < 8000000 || rate > 27000000) {
			printk(KERN_ERR "Error: aic32x4 mclk freq %d out of range!\n",
				   rate);
			clk_put(ssi_ext1);
			return -1;
	}

	clk_set_parent(ssi_ext1, clk_parent); 
	clk_set_rate(ssi_ext1, rate);
	clk_enable(ssi_ext1);
	aic32x4_data.sysclk = rate;

	mxc_aic32x4_amp_enable(1);
	return 0;
}

static struct platform_device mxc_sgtl5000_device = {
	.name = "imx-3stack-sgtl5000",
};
static struct platform_device mxc_aic32x4_device = {
	.name = "imx-3stack-sgtl5000",  //using this code generically with changes for now
};

static struct android_pmem_platform_data android_pmem_data = {
	.name = "pmem_adsp",
	.size = SZ_32M,
};

static struct android_pmem_platform_data android_pmem_gpu_data = {
	.name = "pmem_gpu",
	.size = SZ_64M,
	.cached = 1,
};

static char *usb_functions_ums[] = {
	"usb_mass_storage",
};

static char *usb_functions_ums_adb[] = {
	"usb_mass_storage",
	"adb",
};

static char *usb_functions_rndis[] = {
	"rndis",
};

static char *usb_functions_rndis_adb[] = {
	"rndis",
	"adb",
};

static char *usb_functions_all[] = {
	"rndis",
	"usb_mass_storage",
	"adb"
};

static struct android_usb_product usb_products[] = {
	{
		.product_id	= 0x0c01,
		.num_functions	= ARRAY_SIZE(usb_functions_ums),
		.functions	= usb_functions_ums,
	},
	{
		.product_id	= 0x0c02,
		.num_functions	= ARRAY_SIZE(usb_functions_ums_adb),
		.functions	= usb_functions_ums_adb,
	},
	{
		.product_id	= 0x0c10,
		.num_functions	= ARRAY_SIZE(usb_functions_rndis),
		.functions	= usb_functions_rndis,
	},

};

static struct usb_mass_storage_platform_data mass_storage_data = {
	.nluns		= 3,
	.vendor		= "Freescale",
	.product	= "MX53 QS Android Phone",
	.release	= 0x0100,
};

static struct usb_ether_platform_data rndis_data = {
	.vendorID	= 0x15a2,
	.vendorDescr	= "Freescale",
};

static struct android_usb_platform_data android_usb_data = {
	.vendor_id      = 0x15a2,
	.product_id     = 0x0c01,
	.version        = 0x0100,
	.product_name   = "MX53 QS Android Phone",
	.manufacturer_name = "Freescale",
	.num_products = ARRAY_SIZE(usb_products),
	.products = usb_products,
	.num_functions = ARRAY_SIZE(usb_functions_all),
	.functions = usb_functions_all,
};

static struct mxc_asrc_platform_data mxc_asrc_data = {
	.channel_bits = 4,
	.clk_map_ver = 2,
};

static struct mxc_spdif_platform_data mxc_spdif_data = {
	.spdif_tx = 1,
	.spdif_rx = 0,
	.spdif_clk_44100 = -1,	/* Souce from CKIH1 for 44.1K */
	/* Source from CCM spdif_clk (24M) for 48k and 32k
	 * It's not accurate
	 */
	.spdif_clk_48000 = 1,
	.spdif_clkid = 0,
	.spdif_clk = NULL,	/* spdif bus clk */
};

static struct mxc_audio_platform_data spdif_audio_data = {
	.ext_ram_tx = 1,
};

static struct platform_device mxc_spdif_audio_device = {
	.name = "imx-spdif-audio-device",
};

static void mx53_loco_usbh1_vbus(bool on)
{
	if (on);
//RJK pin overloaded for audio on tst600		gpio_set_value(USB_PWREN, 1);
	else;
//RJK pin overloaded for audio for tst600		gpio_set_value(USB_PWREN, 0);
}

#if defined(CONFIG_KEYBOARD_GPIO) || defined(CONFIG_KEYBOARD_GPIO_MODULE)
#define GPIO_BUTTON(gpio_num, ev_code, act_low, descr, wake)	\
{								\
	.gpio		= gpio_num,				\
	.type		= EV_KEY,				\
	.code		= ev_code,				\
	.active_low	= act_low,				\
	.desc		= "btn " descr,				\
	.wakeup		= wake,					\
}

static struct gpio_keys_button loco_buttons[] = {
	GPIO_BUTTON(MX53_nONKEY, KEY_POWER, 1, "power", 0),
	GPIO_BUTTON(USER_UI1, KEY_BACK, 1, "back", 0),
	GPIO_BUTTON(USER_UI2, KEY_HOME, 1, "home", 0),
};

static struct gpio_keys_platform_data loco_button_data = {
	.buttons	= loco_buttons,
	.nbuttons	= ARRAY_SIZE(loco_buttons),
};

static struct platform_device loco_button_device = {
	.name		= "gpio-keys",
	.id		= -1,
	.num_resources  = 0,
	.dev		= {
		.platform_data = &loco_button_data,
	}
};

static void __init loco_add_device_buttons(void)
{
	platform_device_register(&loco_button_device);
}
#else
static void __init loco_add_device_buttons(void) {}
#endif

static void mxc_register_powerkey(pwrkey_callback pk_cb)
{
	pmic_event_callback_t power_key_event;

	power_key_event.param = (void *)1;
	power_key_event.func = (void *)pk_cb;
	pmic_event_subscribe(EVENT_PWRONI, power_key_event);
}

static int mxc_pwrkey_getstatus(int id)
{
	int sense;

	pmic_read_reg(REG_INT_SENSE1, &sense, 0xffffffff);
printk(KERN_ERR "RJK: REG_INT_SENSE1=0x%x\n", sense);
	if (sense & (1 << 3))
		return 0;

	return 1;
}

static struct power_key_platform_data pwrkey_data = {
	.key_value = KEY_F4,
	.register_pwrkey = mxc_register_powerkey,
	.get_key_status = mxc_pwrkey_getstatus,
};

/*!
 * Board specific fixup function. It is called by \b setup_arch() in
 * setup.c file very early on during kernel starts. It allows the user to
 * statically fill in the proper values for the passed-in parameters. None of
 * the parameters is used currently.
 *
 * @param  desc         pointer to \b struct \b machine_desc
 * @param  tags         pointer to \b struct \b tag
 * @param  cmdline      pointer to the command line
 * @param  mi           pointer to \b struct \b meminfo
 */
static void __init fixup_mxc_board(struct machine_desc *desc, struct tag *tags,
				   char **cmdline, struct meminfo *mi)
{
	struct tag *t;
	struct tag *mem_tag = 0;
	int total_mem = SZ_1G;
	int left_mem = 0;
	int gpu_mem = SZ_128M;
	int fb_mem = SZ_32M;
	char *str;

	mxc_set_cpu_type(MXC_CPU_MX53);

	for_each_tag(mem_tag, tags) {
		if (mem_tag->hdr.tag == ATAG_MEM) {
			total_mem = mem_tag->u.mem.size;
			break;
		}
	}

	for_each_tag(t, tags) {
		if (t->hdr.tag == ATAG_CMDLINE) {
			str = t->u.cmdline.cmdline;
			str = strstr(str, "mem=");
			if (str != NULL) {
				str += 4;
				left_mem = memparse(str, &str);
			}

			str = t->u.cmdline.cmdline;
			str = strstr(str, "gpu_nommu");
			if (str != NULL)
				gpu_data.enable_mmu = 0;

			str = t->u.cmdline.cmdline;
			str = strstr(str, "gpu_memory=");
			if (str != NULL) {
				str += 11;
				gpu_mem = memparse(str, &str);
			}

			break;
		}
	}

	if (gpu_data.enable_mmu)
		gpu_mem = 0;

	if (left_mem == 0 || left_mem > total_mem)
		left_mem = total_mem - gpu_mem - fb_mem;

	if (mem_tag) {
		fb_mem = total_mem - left_mem - gpu_mem;
		if (fb_mem < 0) {
			gpu_mem = total_mem - left_mem;
			fb_mem = 0;
		}
		mem_tag->u.mem.size = left_mem;

		/*reserve memory for gpu*/
		if (!gpu_data.enable_mmu) {
			gpu_device.resource[5].start =
				mem_tag->u.mem.start + left_mem;
			gpu_device.resource[5].end =
				gpu_device.resource[5].start + gpu_mem - 1;
		}
#if defined(CONFIG_FB_MXC_SYNC_PANEL) || \
	defined(CONFIG_FB_MXC_SYNC_PANEL_MODULE)
		if (fb_mem) {
			mxcfb_resources[0].start =
				gpu_data.enable_mmu ?
				mem_tag->u.mem.start + left_mem :
				gpu_device.resource[5].end + 1;
			mxcfb_resources[0].end =
				mxcfb_resources[0].start + fb_mem - 1;
		} else {
			mxcfb_resources[0].start = 0;
			mxcfb_resources[0].end = 0;
		}
#endif
	}
}

int getProductID(void)
{
    int bits=0;
    int x=0;
    int id=0;

    // Read product ID and revision ID from mx53(tst600 or tsw1050)
    for(x=0;x<6;x++) {
        bits=gpio_get_value(PROD_ID0+x);
        id |= (bits << x);
    }
    gProductId=id;

    id=0;
    for(x=0;x<4;x++) {
        bits=gpio_get_value(PROD_REV0+x);
        id |= (bits << x);
    }
    gProductRev=id;

    switch(gProductId) {
    case TSW550:
	printk(KERN_ERR "Product id/rev = 0x%x/0x%x : TSW550\n", gProductId, gProductRev);
	break;
    case TSW1050:
	printk(KERN_ERR "Product id/rev = 0x%x/0x%x : TSW1050\n", gProductId, gProductRev);
	break;
    case TST600:
	printk(KERN_ERR "Product id/rev = 0x%x/0x%x : TST600\n", gProductId, gProductRev);
	break;
    case TST900:
	printk(KERN_ERR "Product id/rev = 0x%x/0x%x : TST900\n", gProductId, gProductRev);
	break;
    case TSW750:
	printk(KERN_ERR "Product id/rev = 0x%x/0x%x : TSW750\n", gProductId, gProductRev);
	break;
    default:
        gProductId=TST600;
	printk(KERN_ERR "defaulted: Product id/rev = 0x%x/0x%x : TST600\n", gProductId, gProductRev);
        break;
    }
    return gProductId;
}

static void __init mx53_tsw550_io_init(void)
{
    int err = 0;
    printk(KERN_INFO "Performing 550 io init\n");
    err = mxc_iomux_v3_setup_multiple_pads(mx53_tsw550_pads,
                                           ARRAY_SIZE(mx53_tsw550_pads));
    if(err) {
        printk(KERN_ERR "Error initializing 550 io pins");
    }
    /* SD3 */
    gpio_request(SD3_CD_N, "sd3-cd_n");
    gpio_direction_input(SD3_CD_N);
    gpio_request(SD3_WP, "sd3-wp");
    gpio_direction_input(SD3_WP);

    /* reset FEC PHY */
    gpio_request(FEC_RST, "fec-rst");
    gpio_direction_output(FEC_RST, 0);
    gpio_set_value(FEC_RST, 0);
    msleep(1);
    gpio_set_value(FEC_RST, 1);


    gpio_request(DISP1_POWER_3V3, "disp1-power-3V3");
    gpio_direction_output(DISP1_POWER_3V3, 0);
    gpio_request(DISPL_BUF_EN_3V3_N, "displ_buf_en_3v3_n");
	gpio_direction_output(DISPL_BUF_EN_3V3_N, 1);
	gpio_request(DISP1_STANDBY_N, "displ_standby_n");
	gpio_direction_output(DISP1_STANDBY_N, 0);
    gpio_request(DISP1_BKLT_EN_3V3, "disp1_bklt_en_3v3");
    gpio_direction_output(DISP1_BKLT_EN_3V3, 0);

    // TSW550 touchscreen
    gpio_request(CAP_TS_RST_N, "cap_ts_rst_n");
    gpio_direction_output(CAP_TS_RST_N, 1);
    gpio_request(CAP_TS_INT_N, "cap_ts_int_n");
    gpio_direction_input(CAP_TS_INT_N);
    msleep(10);

    /* TSW550 50MHZ osc enables clk for FEC */
    gpio_request(MHZ_50_OSC_EN, "mhz_50_osc_en");
    gpio_direction_output(MHZ_50_OSC_EN, 1);
    gpio_set_value(MHZ_50_OSC_EN, 1);
    msleep(10);
#if 0 //need to remove
    /* TSW550 FEC_PWR_ON  */
    gpio_request(FEC_PWR_ON, "fec_pwr_on");
    gpio_direction_output(FEC_PWR_ON, 1);
    gpio_set_value(FEC_PWR_ON, 1);
    msleep(10);
#endif
    /* audio tlv320 */
#ifndef DEBUG_AMP
    gpio_request(AMP_SD_N, "amp_sd_n");
    gpio_direction_output(AMP_SD_N, 1);
#endif
    gpio_request(CODEC_INT_OUT, "codec_int_out");
    gpio_direction_input(CODEC_INT_OUT);

    gpio_request(CODEC_RST_3V3_N, "codec_rst_3v3");
    gpio_direction_output(CODEC_RST_3V3_N, 0);

    gpio_request(I2S_LRCLK, "i2s_lrclk");
    gpio_direction_output(I2S_LRCLK, 0);
    gpio_request(I2S_SCLK, "i2s_sclk");
    gpio_direction_output(I2S_SCLK, 0);
    gpio_request(I2S_DOUT, "i2s_dout");
    gpio_direction_output(I2S_DOUT, 0);
    gpio_request(I2S_DIN, "i2s_din");
    gpio_direction_input(I2S_DIN);
    msleep(10);

//RJK LCD additions   -- This matches Panel_Enable in WinCE under bootloader/display/ebootdisplay.c
    /* in tst600 video driver */
    msleep(20);
    msleep(20);
    gpio_set_value(DISP1_POWER_3V3, 1);
    msleep(20);
    gpio_set_value(DISPL_BUF_EN_3V3_N, 0);
    msleep(500);
    gpio_set_value(DISP1_STANDBY_N, 1);
    msleep(20);
    gpio_set_value(DISP1_BKLT_EN_3V3, 1);
    msleep(20);

/* #define LEDS_RST_3V3            (1*32 + 7)  // GPIO_2_7 */
/* #define MIC_SEL_3V3             (1*32 + 13) // GPIO_2_13 */
    // Doesn't exist on the 750
    /* gpio_set_value(VLED_EN_3V3,1); */
    /* msleep(20); */
    /* gpio_set_value(VLED_SIG_EN,0); */
    /* msleep(10); */
    gpio_set_value(LEDS_RST_3V3, 0);
    msleep(20);
    gpio_request(MIC_SEL_3V3, "mic_sel_3v3");
    gpio_direction_output(MIC_SEL_3V3, 1);
    msleep(10);

    gpio_set_value(DISP1_BKLT_EN_3V3, 1);
    msleep(50);
}

static void __init mx53_tst600_io_init(void)
{
    int err = 0;
    printk(KERN_INFO "DMM: Performing 600 io init\n");
    err = mxc_iomux_v3_setup_multiple_pads(mx53_tst600_pads,
                                           ARRAY_SIZE(mx53_tst600_pads));
    if(err) {
        printk(KERN_ERR "DMM: Error initializing 600 io pins");
    }
    /* SD3 */
    gpio_request(SD3_CD_N, "sd3-cd_n");
    gpio_direction_input(SD3_CD_N);
    gpio_request(SD3_WP, "sd3-wp");
    gpio_direction_input(SD3_WP);

    /* reset FEC PHY */
    gpio_request(FEC_RST, "fec-rst");
    gpio_direction_output(FEC_RST, 0);
    gpio_set_value(FEC_RST, 0);
    msleep(1);
    gpio_set_value(FEC_RST, 1);

    /* headphone_det_b */
//RJK   gpio_request(HEADPHONE_DEC_B, "headphone-dec");
//RJK   gpio_direction_input(HEADPHONE_DEC_B);

    /* USB PWR enable */
//RJK   gpio_request(USB_PWREN, "usb-pwr");
//RJK   gpio_direction_output(USB_PWREN, 0);

    /* Crestron dock LED */
    gpio_request(DOCK_CHG_INDICATOR, "dock_chg_indicator");
    gpio_direction_output(DOCK_CHG_INDICATOR, 0);

//RJK LCD additions   -- This matches DisplayIOMUXSetup in WinCE under bootloader/display/ebootdisplay.c
    /* LCD panel power enable (88)*/
    gpio_request(DISP0_POWER_EN, "disp0-power-en");
    gpio_direction_output(DISP0_POWER_EN, 0);
    gpio_request(LCD_BK_PWR_EN, "lcd_bk_pwr_en");
    gpio_direction_output(LCD_BK_PWR_EN, 0);
    gpio_request(DISPL_BUF_EN_N, "displ_buf_en_n");
    gpio_direction_output(DISPL_BUF_EN_N, 1);

    //gpio_request(LCD_BK_ON, "lcd_bk_on");
    gpio_request(LCD_BLT_EN, "lcd_blt_en");
    //gpio_direction_output(LCD_BK_ON, 0);
    gpio_direction_output(LCD_BLT_EN, 0);
    gpio_request(LCD_H_FLIP, "lcd_h_flip");
    gpio_direction_output(LCD_H_FLIP, 0);
    gpio_request(LCD_V_FLIP, "lcd_v_flip");
    gpio_direction_output(LCD_V_FLIP, 0);
    //gpio_request(LCD_PWM_EN, "lcd_pwm_en");
    //gpio_direction_output(LCD_PWM_EN, 0);

    gpio_request(POWER_5V_ON, "power_5v_on");
    gpio_direction_output(POWER_5V_ON, 1);
    gpio_request(POWER_12V_ON, "power_12v_on");
    gpio_direction_output(POWER_12V_ON, 0);

    // TST600 touchscreen
    gpio_request(CAP_TS_RST_N, "cap_ts_rst_n");
    gpio_direction_output(CAP_TS_RST_N, 1);
    gpio_request(CAP_TS_INT_N, "cap_ts_int_n");
    gpio_direction_input(CAP_TS_INT_N);
    msleep(10);
    /* tst600 key-switch */

    gpio_request(KEY_INT_N, "key_int_n");
    gpio_direction_input(KEY_INT_N);
    gpio_request(BKLIGHT_CTRL, "bklight_ctrl");
    gpio_direction_input(BKLIGHT_CTRL);
    gpio_request(ACT_STBY, "act_stby");
    gpio_direction_input(ACT_STBY);
    msleep(10);

    /* TST600 50MHZ osc enables clk for FEC */
    gpio_request(MHZ_50_OSC_EN, "mhz_50_osc_en");
    gpio_direction_output(MHZ_50_OSC_EN, 1);
    gpio_set_value(MHZ_50_OSC_EN, 1);
    msleep(10);
    /* TST600 FEC_PWR_ON  */
    gpio_request(FEC_PWR_ON, "fec_pwr_on");
    gpio_direction_output(FEC_PWR_ON, 1);
    gpio_set_value(FEC_PWR_ON, 1);
    msleep(10);

    /* WIFI */
    gpio_request(WIFI_ON, "wifi_on");
    gpio_direction_output(WIFI_ON, 1);
    gpio_set_value(WIFI_ON, 1);
    msleep(10);

    /* audio tlv320 */
#ifndef DEBUG_AMP
    gpio_request(AMP_SD_N, "amp_sd_n");
    gpio_direction_output(AMP_SD_N, 1);
#endif
    gpio_request(CODEC_INT_OUT, "codec_int_out");
    gpio_direction_input(CODEC_INT_OUT);
    gpio_request(CODEC_RESET_N, "codec_reset_n");
    gpio_direction_output(CODEC_RESET_N, 0);
    gpio_request(I2S_LRCLK, "i2s_lrclk");
    gpio_direction_output(I2S_LRCLK, 0);
    gpio_request(I2S_SCLK, "i2s_sclk");
    gpio_direction_output(I2S_SCLK, 0);
    gpio_request(I2S_DOUT, "i2s_dout");
    gpio_direction_output(I2S_DOUT, 0);
    gpio_request(I2S_DIN, "i2s_din");
    gpio_direction_input(I2S_DIN);
    msleep(10);

//RJK LCD additions   -- This matches Panel_Enable in WinCE under bootloader/display/ebootdisplay.c
    /* in tst600 video driver */
    gpio_set_value(POWER_12V_ON, 1);
    msleep(10);

    gpio_set_value(POWER_5V_ON, 1);

    gpio_set_value(DISP0_POWER_EN, 1);
    msleep(2);

    gpio_set_value(LCD_V_FLIP, 1);
    gpio_set_value(LCD_H_FLIP, 0); 
    gpio_set_value(DISPL_BUF_EN_N, 0);
    msleep(200);

    gpio_set_value(LCD_BK_PWR_EN, 1);
    //gpio_set_value(LCD_BK_ON, 1);
    gpio_set_value(LCD_BLT_EN, 1);

//        gpio_set_value(POWER_5V_ON, 1);
}

static void __init mx53_tst900_io_init(void)
{
    int err = 0;
    printk(KERN_INFO "DMM: Performing 900 io init\n");
    err = mxc_iomux_v3_setup_multiple_pads(mx53_tst900_pads,
                                           ARRAY_SIZE(mx53_tst900_pads));
    if(err) {
        printk(KERN_ERR "DMM: Error initializing 900 io pins");
    }
    /* SD3 */
    gpio_request(SD3_CD_N, "sd3-cd_n");
    gpio_direction_input(SD3_CD_N);
    gpio_request(SD3_WP, "sd3-wp");
    gpio_direction_input(SD3_WP);

    /* reset FEC PHY */
    gpio_request(FEC_RST, "fec-rst");
    gpio_direction_output(FEC_RST, 0);
    gpio_set_value(FEC_RST, 0);
    msleep(1);
    gpio_set_value(FEC_RST, 1);

    /* headphone_det_b */
//RJK   gpio_request(HEADPHONE_DEC_B, "headphone-dec");
//RJK   gpio_direction_input(HEADPHONE_DEC_B);

    /* USB PWR enable */
//RJK   gpio_request(USB_PWREN, "usb-pwr");
//RJK   gpio_direction_output(USB_PWREN, 0);

    /* Crestron dock LED */
    gpio_request(DOCK_CHG_INDICATOR, "dock_chg_indicator");
    gpio_direction_output(DOCK_CHG_INDICATOR, 0);

//RJK LCD additions   -- This matches DisplayIOMUXSetup in WinCE under bootloader/display/ebootdisplay.c
    /* LCD panel power enable (88)*/
    gpio_request(DISP0_POWER_EN, "disp0-power-en");
    gpio_direction_output(DISP0_POWER_EN, 0);
    gpio_request(LCD_BK_PWR_EN, "lcd_bk_pwr_en");
    gpio_direction_output(LCD_BK_PWR_EN, 0);
    gpio_request(DISPL_BUF_EN_N, "displ_buf_en_n");
    gpio_direction_output(DISPL_BUF_EN_N, 1);

    //gpio_request(LCD_BK_ON, "lcd_bk_on");
    gpio_request(LCD_BLT_EN, "lcd_blt_en");
    //gpio_direction_output(LCD_BK_ON, 0);
    gpio_direction_output(LCD_BLT_EN, 0);
    gpio_request(LCD_H_FLIP, "lcd_h_flip");
    gpio_direction_output(LCD_H_FLIP, 0);
    gpio_request(LCD_V_FLIP, "lcd_v_flip");
    gpio_direction_output(LCD_V_FLIP, 0);
    //gpio_request(LCD_PWM_EN, "lcd_pwm_en");
    //gpio_direction_output(LCD_PWM_EN, 0);

    gpio_request(POWER_5V_ON, "power_5v_on");
    gpio_direction_output(POWER_5V_ON, 1);
    gpio_request(POWER_12V_ON, "power_12v_on");
    gpio_direction_output(POWER_12V_ON, 0);

    // TST900 touchscreen
    gpio_request(CAP_TS_RST_N, "cap_ts_rst_n");
    gpio_direction_output(CAP_TS_RST_N, 1);
    gpio_request(CAP_TS_INT_N, "cap_ts_int_n");
    gpio_direction_input(CAP_TS_INT_N);
    msleep(10);
    /* tst900 key-switch */

    gpio_request(KEY_INT_N, "key_int_n");
    gpio_direction_input(KEY_INT_N);
    gpio_request(BKLIGHT_CTRL, "bklight_ctrl");
    gpio_direction_input(BKLIGHT_CTRL);
    gpio_request(ACT_STBY, "act_stby");
    gpio_direction_input(ACT_STBY);
    msleep(10);

    /* TST900 50MHZ osc enables clk for FEC */
    gpio_request(MHZ_50_OSC_EN, "mhz_50_osc_en");
    gpio_direction_output(MHZ_50_OSC_EN, 1);
    gpio_set_value(MHZ_50_OSC_EN, 1);
    msleep(10);
#if 0 //need to remove
    /* TST900 FEC_PWR_ON  */
    gpio_request(FEC_PWR_ON, "fec_pwr_on");
    gpio_direction_output(FEC_PWR_ON, 1);
    gpio_set_value(FEC_PWR_ON, 1);
    msleep(10);
#endif

    /* WIFI */
    gpio_request(WIFI_ON, "wifi_on");
    gpio_direction_output(WIFI_ON, 1);
    gpio_set_value(WIFI_ON, 1);
    msleep(10);

    /* audio tlv320 */
#ifndef DEBUG_AMP
    gpio_request(AMP_SD_N, "amp_sd_n");
    gpio_direction_output(AMP_SD_N, 1);
#endif
    gpio_request(CODEC_INT_OUT, "codec_int_out");
    gpio_direction_input(CODEC_INT_OUT);
    gpio_request(CODEC_RESET_N, "codec_reset_n");
    gpio_direction_output(CODEC_RESET_N, 0);
    gpio_request(I2S_LRCLK, "i2s_lrclk");
    gpio_direction_output(I2S_LRCLK, 0);
    gpio_request(I2S_SCLK, "i2s_sclk");
    gpio_direction_output(I2S_SCLK, 0);
    gpio_request(I2S_DOUT, "i2s_dout");
    gpio_direction_output(I2S_DOUT, 0);
    gpio_request(I2S_DIN, "i2s_din");
    gpio_direction_input(I2S_DIN);
    msleep(10);

//RJK LCD additions   -- This matches Panel_Enable in WinCE under bootloader/display/ebootdisplay.c
    /* in tst600 video driver */
    gpio_set_value(POWER_12V_ON, 1);
    msleep(10);

    gpio_set_value(POWER_5V_ON, 1);

    gpio_set_value(DISP0_POWER_EN, 1);
    msleep(2);

    gpio_set_value(LCD_V_FLIP, 1);
    gpio_set_value(LCD_H_FLIP, 0);
    gpio_set_value(DISPL_BUF_EN_N, 0);
    msleep(200);

    gpio_set_value(LCD_BK_PWR_EN, 1);
    //gpio_set_value(LCD_BK_ON, 1);
    gpio_set_value(LCD_BLT_EN, 1);

//        gpio_set_value(POWER_5V_ON, 1);
}

static void __init mx53_tsw750_io_init(void)
{
    int err = 0;
    int rl_err = 0;
    int ud_err = 0;
    int rl = -1;
    int ud = -1;
    printk(KERN_INFO "DMM: Performing 750 io init\n");
    err = mxc_iomux_v3_setup_multiple_pads(mx53_tsw750_pads,
                                           ARRAY_SIZE(mx53_tsw750_pads));
    if(err) {
        printk(KERN_ERR "DMM: Error initializing 750 io pins");
    }
    /* SD3 */
    gpio_request(SD3_CD_N, "sd3-cd_n");
    gpio_direction_input(SD3_CD_N);
    gpio_request(SD3_WP, "sd3-wp");
    gpio_direction_input(SD3_WP);

    /* reset FEC PHY */
    gpio_request(FEC_RST, "fec-rst");
    gpio_direction_output(FEC_RST, 0);
    gpio_set_value(FEC_RST, 0);
    msleep(1);
    gpio_set_value(FEC_RST, 1);

    /* Set display panel direction Right-Left/Up-Down */
    rl_err = gpio_request(DISP1_RL_2V775, "disp1_rl_2v775");
    gpio_direction_output(DISP1_RL_2V775, 1);
    // Uncomment the gpio_free() calls to access from /sys/class/gpio
    //gpio_free(DISP1_RL_2V775);
    ud_err = gpio_request(DISP1_UD_2V775, "disp1_ud_2v775");
    gpio_direction_output(DISP1_UD_2V775, 0);
    //gpio_free(DISP1_UD_2V775);
    rl = gpio_get_value(DISP1_RL_2V775);
    ud = gpio_get_value(DISP1_UD_2V775);
    // gpio_set_value(DISP1_RL_2V775, 1);
    // gpio_request(LCD_H_FLIP, "lcd_h_flip");
    // gpio_direction_output(LCD_H_FLIP, 1);
    gpio_request(LCD_BUFF_EN, "lcd_buff_en");
    gpio_direction_output(LCD_BUFF_EN, 1);
    msleep(250);
    gpio_set_value(LCD_BUFF_EN, 0);

    msleep(100);

    gpio_request(DISP1_POWER_3V3, "disp1-power-3V3");
    gpio_direction_output(DISP1_POWER_3V3, 0);
    gpio_request(LCD_BUFF_EN, "lcd_buff_en");
    gpio_direction_output(LCD_BUFF_EN, 1);
    gpio_request(DISP1_BKLT_EN_3V3, "disp1_bklt_en_3v3");
    gpio_direction_output(DISP1_BKLT_EN_3V3, 0);
    // Doesn't exist on the 750
    /* gpio_request(VLED_EN_3V3, "vled_en_3v3"); */
    /* gpio_direction_output(VLED_EN_3V3, 0); */
    /* gpio_request(VLED_SIG_EN, "vled_sig_en"); */
    /* gpio_direction_output(VLED_SIG_EN, 1); */
    // TSW750 touchscreen
    gpio_request(CAP_TS_RST_N, "cap_ts_rst_n");
    gpio_direction_output(CAP_TS_RST_N, 1);
    gpio_request(CAP_TS_INT_N, "cap_ts_int_n");
    gpio_direction_input(CAP_TS_INT_N);
    msleep(10);

    /* TSW750 50MHZ osc enables clk for FEC */
    gpio_request(MHZ_50_OSC_EN, "mhz_50_osc_en");
    gpio_direction_output(MHZ_50_OSC_EN, 1);
    gpio_set_value(MHZ_50_OSC_EN, 1);
    msleep(10);
#if 0 //need to remove
    /* TSW750 FEC_PWR_ON  */
    gpio_request(FEC_PWR_ON, "fec_pwr_on");
    gpio_direction_output(FEC_PWR_ON, 1);
    gpio_set_value(FEC_PWR_ON, 1);
    msleep(10);
#endif

    /* audio tlv320 */
#ifndef DEBUG_AMP
    gpio_request(AMP_SD_N, "amp_sd_n");
    gpio_direction_output(AMP_SD_N, 1);
#endif
    gpio_request(CODEC_INT_OUT, "codec_int_out");
    gpio_direction_input(CODEC_INT_OUT);

    gpio_request(CODEC_RST_3V3_N, "codec_rst_3v3");
    gpio_direction_output(CODEC_RST_3V3_N, 0);

    gpio_request(I2S_LRCLK, "i2s_lrclk");
    gpio_direction_output(I2S_LRCLK, 0);
    gpio_request(I2S_SCLK, "i2s_sclk");
    gpio_direction_output(I2S_SCLK, 0);
    gpio_request(I2S_DOUT, "i2s_dout");
    gpio_direction_output(I2S_DOUT, 0);
    gpio_request(I2S_DIN, "i2s_din");
    gpio_direction_input(I2S_DIN);
    msleep(10);

//RJK LCD additions   -- This matches Panel_Enable in WinCE under bootloader/display/ebootdisplay.c
    /* in tst600 video driver */
    msleep(20);
    gpio_set_value(DISP1_POWER_3V3, 1);
    msleep(20);
    gpio_set_value(LCD_BUFF_EN, 0);
    msleep(250);

/* #define LEDS_RST_3V3            (1*32 + 7)  // GPIO_2_7 */
/* #define MIC_SEL_3V3             (1*32 + 13) // GPIO_2_13 */
    // DMM: Doesn't exist on the 750
    /* gpio_set_value(VLED_EN_3V3,1); */
    /* msleep(20); */
    /* gpio_set_value(VLED_SIG_EN,0); */
    /* msleep(10); */
    gpio_set_value(LEDS_RST_3V3, 0);
    msleep(20);
    gpio_request(MIC_SEL_3V3, "mic_sel_3v3");
	gpio_direction_output(MIC_SEL_3V3, 1);
    msleep(10);

    gpio_set_value(DISP1_BKLT_EN_3V3, 1);
    msleep(50);
}

static void __init mx53_tsw1050_io_init(void)
{
    int err = 0;
    printk(KERN_INFO "DMM: Performing 1050 io init\n");
    err = mxc_iomux_v3_setup_multiple_pads(mx53_tsw1050_pads,
                                           ARRAY_SIZE(mx53_tsw1050_pads));
    if(err) {
        printk(KERN_ERR "DMM: Error intializing 1050 io pins");
    }
    /* SD3 */
    gpio_request(SD3_CD_N, "sd3-cd_n");
    gpio_direction_input(SD3_CD_N);
    gpio_request(SD3_WP, "sd3-wp");
    gpio_direction_input(SD3_WP);

    /* reset FEC PHY */
    gpio_request(FEC_RST, "fec-rst");
    gpio_direction_output(FEC_RST, 0);
    gpio_set_value(FEC_RST, 0);
    msleep(1);
    gpio_set_value(FEC_RST, 1);

    /* headphone_det_b */
//RJK   gpio_request(HEADPHONE_DEC_B, "headphone-dec");
//RJK   gpio_direction_input(HEADPHONE_DEC_B);

    /* USB PWR enable */
//RJK   gpio_request(USB_PWREN, "usb-pwr");
//RJK   gpio_direction_output(USB_PWREN, 0);

#ifndef NO_1050_LCD //RJK to access pins manually from command line
    gpio_request(DISP1_POWER_3V3, "disp1-power-3V3");
    gpio_direction_output(DISP1_POWER_3V3, 0);
    gpio_request(LCD_BUFF_EN, "lcd_buff_en");
    gpio_direction_output(LCD_BUFF_EN, 1);
    gpio_request(DISP1_BKLT_EN_3V3, "disp1_bklt_en_3v3");
    gpio_direction_output(DISP1_BKLT_EN_3V3, 0);
    gpio_request(VLED_EN_3V3, "vled_en_3v3");
    gpio_direction_output(VLED_EN_3V3, 0);
    gpio_request(VLED_SIG_EN, "vled_sig_en");
    gpio_direction_output(VLED_SIG_EN, 1);
#endif
    // TSW1050 touchscreen
    gpio_request(CAP_TS_RST_N, "cap_ts_rst_n");
    gpio_direction_output(CAP_TS_RST_N, 1);
    gpio_request(CAP_TS_INT_N, "cap_ts_int_n");
    gpio_direction_input(CAP_TS_INT_N);
    msleep(10);

    /* TSW1050 50MHZ osc enables clk for FEC */
    gpio_request(MHZ_50_OSC_EN, "mhz_50_osc_en");
    gpio_direction_output(MHZ_50_OSC_EN, 1);
    gpio_set_value(MHZ_50_OSC_EN, 1);
    msleep(10);
#if 0 //need to remove
    /* TSW1050 FEC_PWR_ON  */
    gpio_request(FEC_PWR_ON, "fec_pwr_on");
    gpio_direction_output(FEC_PWR_ON, 1);
    gpio_set_value(FEC_PWR_ON, 1);
    msleep(10);
#endif
    /* audio tlv320 */
#ifndef DEBUG_AMP
    gpio_request(AMP_SD_N, "amp_sd_n");
    gpio_direction_output(AMP_SD_N, 1);
#endif
    gpio_request(CODEC_INT_OUT, "codec_int_out");
    gpio_direction_input(CODEC_INT_OUT);
    gpio_request(CODEC_RST_3V3_N, "codec_rst_3v3");
    gpio_direction_output(CODEC_RST_3V3_N, 0);
    gpio_request(I2S_LRCLK, "i2s_lrclk");
    gpio_direction_output(I2S_LRCLK, 0);
    gpio_request(I2S_SCLK, "i2s_sclk");
    gpio_direction_output(I2S_SCLK, 0);
    gpio_request(I2S_DOUT, "i2s_dout");
    gpio_direction_output(I2S_DOUT, 0);
    gpio_request(I2S_DIN, "i2s_din");
    gpio_direction_input(I2S_DIN);
    msleep(10);

//RJK LCD additions   -- This matches Panel_Enable in WinCE under bootloader/display/ebootdisplay.c
    /* in tst600 video driver */
#ifndef NO_1050_LCD //RJK to access pins manually from command line
    gpio_set_value(DISP1_POWER_3V3, 1);
    msleep(20);
    gpio_set_value(LCD_BUFF_EN, 0);
    msleep(250);
    gpio_set_value(VLED_EN_3V3,1);
    msleep(20);
    gpio_set_value(VLED_SIG_EN,0);
    msleep(10);
    gpio_set_value(DISP1_BKLT_EN_3V3, 1);
    msleep(50);
#endif

    gpio_request(MIC_SEL_3V3, "mic_sel_3v3");
	gpio_direction_output(MIC_SEL_3V3, 1);
    msleep(10);
}

static void __init mx53_loco_io_init(void)
{
	int err = 0;
    err = mxc_iomux_v3_setup_multiple_pads(mx53_loco_pads,
                                               ARRAY_SIZE(mx53_loco_pads));
    msleep(3);
    printk(KERN_ERR "***DMM: setup_multiple_pads = %i***", err);

    getProductID(); //This call will set the product Id globals

	/* External Power */
	gpio_request(EXT_PWR_N, "ext_pwr_n");	
	gpio_direction_input(EXT_PWR_N);

	/* power/battery */
	if(gProductId == TST600) {
	    gpio_request(GG_PROG_PULSE, "gg_prog_pulse");
		gpio_direction_output(GG_PROG_PULSE, 0);
	}

	/* watch Dog */
	gpio_request(WD_ENABLE, "wd_enable");	
	gpio_direction_output(WD_ENABLE, 1);

	/* crestron product ID and REV */
	gpio_request(PROD_ID0, "prod_id0");
	gpio_request(PROD_ID1, "prod_id1");
	gpio_request(PROD_ID2, "prod_id2");
	gpio_request(PROD_ID3, "prod_id3");
	gpio_request(PROD_ID4, "prod_id4");
	gpio_request(PROD_ID5, "prod_id5");

	gpio_request(PROD_REV0, "prod_rev0");
	gpio_request(PROD_REV1, "prod_rev1");
	gpio_request(PROD_REV2, "prod_rev2");
	gpio_request(PROD_REV3, "prod_rev3");

    // Setup just the common essentials before configuring the others per board.
    switch(gProductId) {
		case TSW550: mx53_tsw550_io_init(); break;
		case TST600: mx53_tst600_io_init(); break;
		case TST900: mx53_tst900_io_init(); break;
		case TSW750: mx53_tsw750_io_init(); break;
		case TSW1050:mx53_tsw1050_io_init(); break;
		default: break;
    }
}

static void __init mxc_tst600_board_init(void)
{
	mxc_register_device(&mxcsdhc1_device, &mmc1_data);
	mxc_register_device(&mxcsdhc3_device, &mmc3_data);

//	mxc_register_device(&usb_mass_storage_device, &mass_storage_data);
//	mxc_register_device(&usb_rndis_device, &rndis_data);
//	mxc_register_device(&android_usb_device, &android_usb_data);

	i2c_register_board_info(0, mxc_i2c0_600, ARRAY_SIZE(mxc_i2c0_600));
	i2c_register_board_info(1, mxc_i2c1_600, ARRAY_SIZE(mxc_i2c1_600));
	i2c_register_board_info(2, mxc_i2c2_600, ARRAY_SIZE(mxc_i2c2_600));

	mx5_usb_dr_init();
//	mx5_set_host1_vbus_func(mx53_loco_usbh1_vbus); 	//no power pin on 600
//  will freeze panel with usbh1 enabled
//	mx5_usbh1_init();								//usbh1 is not used on 600 
}

static void __init mxc_tst900_board_init(void)
{
	mxc_register_device(&mxc_ldb_device, &ldb_data);

	mxc_register_device(&mxcsdhc1_device, &mmc1_data);
	mxc_register_device(&mxcsdhc2_device, &mmc2_data);
	mxc_register_device(&mxcsdhc3_device, &mmc3_data);

//	mxc_register_device(&usb_mass_storage_device, &mass_storage_data);
//	mxc_register_device(&usb_rndis_device, &rndis_data);
//	mxc_register_device(&android_usb_device, &android_usb_data);

	i2c_register_board_info(0, mxc_i2c0_900, ARRAY_SIZE(mxc_i2c0_900));
	i2c_register_board_info(1, mxc_i2c1_900, ARRAY_SIZE(mxc_i2c1_900));
	i2c_register_board_info(2, mxc_i2c2_900, ARRAY_SIZE(mxc_i2c2_900));

	mx5_usb_dr_init();
//	mx5_set_host1_vbus_func(mx53_loco_usbh1_vbus);
//  will freeze panel with usbh1 enabled
//	mx5_usbh1_init();
}

static void __init mxc_tsw550_board_init(void)
{
	mxc_register_device(&mxcsdhc1_device, &mmc1_data);

	i2c_register_board_info(0, mxc_i2c0_550, ARRAY_SIZE(mxc_i2c0_550));
	i2c_register_board_info(1, mxc_i2c1_550, ARRAY_SIZE(mxc_i2c1_550));
	i2c_register_board_info(2, mxc_i2c2_550, ARRAY_SIZE(mxc_i2c2_550));
}

static void __init mxc_tsw750_board_init(void)
{
	mxc_register_device(&mxcsdhc1_device, &mmc1_data);

	i2c_register_board_info(0, mxc_i2c0_750, ARRAY_SIZE(mxc_i2c0_750));
	i2c_register_board_info(1, mxc_i2c1_750, ARRAY_SIZE(mxc_i2c1_750));
	i2c_register_board_info(2, mxc_i2c2_750, ARRAY_SIZE(mxc_i2c2_750));
}

static void __init mxc_tsw1050_board_init(void)
{
	mxc_register_device(&mxc_ldb_device, &ldb_data);

	mxc_register_device(&mxcsdhc1_device, &mmc1_data);

	i2c_register_board_info(0, mxc_i2c0_1050, ARRAY_SIZE(mxc_i2c0_1050));
	i2c_register_board_info(1, mxc_i2c1_1050, ARRAY_SIZE(mxc_i2c1_1050));
	i2c_register_board_info(2, mxc_i2c2_1050, ARRAY_SIZE(mxc_i2c2_1050));
}

#define USE_UNKNOWN 0
/*!
 * Board specific initialization.
 */
static void __init mxc_board_init(void)
{

	iomux_v3_cfg_t mc34708_int = MX53_PAD_CSI0_DAT12__GPIO5_30;
	iomux_v3_cfg_t da9052_csi0_d12;

    printk(KERN_ERR "##################### MXC_BOARD_INIT ##########################\n");

	mxc_ipu_data.di_clk[0] = clk_get(NULL, "ipu_di0_clk");
	mxc_ipu_data.di_clk[1] = clk_get(NULL, "ipu_di1_clk");
	mxc_ipu_data.csi_clk[0] = clk_get(NULL, "ssi_ext1_clk");
	//RJK mxc_spdif_data.spdif_core_clk = clk_get(NULL, "spdif_xtal_clk");
	//RJK clk_put(mxc_spdif_data.spdif_core_clk);

	mxcsdhc3_device.resource[2].start = gpio_to_irq(SD3_CD_N);
	mxcsdhc3_device.resource[2].end = gpio_to_irq(SD3_CD_N);

	mxc_cpu_common_init();
	mx53_loco_io_init();   //RJK: prior to this call the product ID is not known......

	//UiHal_file_init(); //this creates a directory in /sdcard called .crestron to put persistent things.

    if(gProductId == TST600) {

        enableLED();    // Turns on the LED when board init starts
        // Careful do not move before io_init()
    }

	mxc_register_device(&mxc_dma_device, NULL);
	mxc_register_device(&mxc_wdt_device, NULL);  //RJK: init WDT watch dog timer
    // Register i2c busses.
	mxc_register_device(&mxci2c_devices[0], &mxci2c_0_data);
	mxc_register_device(&mxci2c_devices[1], &mxci2c_1_data);
	mxc_register_device(&mxci2c_devices[2], &mxci2c_2_data);

    if (board_is_mx53_loco_mc34708()) {
#if USE_UNKNOWN
	/* this is NOT used for Crestron tst600 */
		/* set pmic INT gpo DEBUG pin */
		if (board_is_rev(BOARD_REV_2)) {/*Board rev A*/
			mc34708_int = MX53_PAD_CSI0_DAT12__GPIO5_30;
			mx53_loco_mc34708_irq = MX53_LOCO_MC34708_IRQ_REVA;
		} else if (board_is_rev(BOARD_REV_4)) {/*Board rev B*/
			mc34708_int = MX53_PAD_CSI0_DAT5__GPIO5_23;
			mx53_loco_mc34708_irq = MX53_LOCO_MC34708_IRQ_REVB;
		}
		mxc_iomux_v3_setup_pad(mc34708_int);
		gpio_request(mx53_loco_mc34708_irq, "pmic-int");
		gpio_direction_input(mx53_loco_mc34708_irq);
		mx53_loco_init_mc34708(mx53_loco_mc34708_irq);
		dvfs_core_data.reg_id = "SW1A";
		tve_data.dac_reg = "VDAC";
		bus_freq_data.gp_reg_id = "SW1A";
		bus_freq_data.lp_reg_id = "SW2";
		mxc_register_device(&mxc_powerkey_device, &pwrkey_data);
#endif
	}
    else {

#if 0 //RJK NU on tst600
		da9052_csi0_d12 = MX53_PAD_CSI0_DAT12__IPU_CSI0_D_12;
		mxc_iomux_v3_setup_pad(da9052_csi0_d12);
#endif
        mx53_loco_init_da9052();
		dvfs_core_data.reg_id = "DA9052_BUCK_CORE";
		tve_data.dac_reg = "DA9052_LDO7";    //TVE and DAC power supply (LD07 is regulator)
		bus_freq_data.gp_reg_id = "DA9052_BUCK_CORE";
		bus_freq_data.lp_reg_id = "DA9052_BUCK_PRO";
	}

	mxc_register_device(&mxc_rtc_device, NULL);
	mxc_register_device(&mxc_ipu_device, &mxc_ipu_data);  //RJK from mxc/ipu3 directory (image processing unit)
#if USE_UNKNOWN //television encoder
	mxc_register_device(&mxc_tve_device, &tve_data);
#endif
	if (!mxc_fuse_get_vpu_status())
		mxc_register_device(&mxcvpu_device, &mxc_vpu_data);
	if (!mxc_fuse_get_gpu_status())
		mxc_register_device(&gpu_device, &gpu_data);
#if USE_UNKNOWN
	mxc_register_device(&mxcscc_device, NULL);
#endif
	mxc_register_device(&pm_device, &loco_pm_data);
	mxc_register_device(&mxc_dvfs_core_device, &dvfs_core_data);
#if USE_UNKNOWN
	mxc_register_device(&busfreq_device, &bus_freq_data);
#endif
#if 1 //IC identification Module
	mxc_register_device(&mxc_iim_device, &iim_data);
#endif

//TODO: 900 doesnt use pwm, uses i2c
	mxc_register_device(&mxc_pwm2_device, NULL);
	switch(gProductId) {
	case TST600:
		mxc_pwm_backlight_data.color_depth = 18;
		mxc_pwm_backlight_data.pixel_width = 640;
		mxc_pwm_backlight_data.pixel_height = 480;
		mxc_pwm_backlight_data.mm_height = 115;
		mxc_pwm_backlight_data.mm_width = 86;
		break;
			
	case TSW1050:
		mxc_pwm_backlight_data.invert_brightness = 0;
		mxc_pwm_backlight_data.color_depth = 24;
		mxc_pwm_backlight_data.pixel_width = 1280;
		mxc_pwm_backlight_data.pixel_height = 800;
		mxc_pwm_backlight_data.mm_width = 217;
		mxc_pwm_backlight_data.mm_height = 136;
		break;
		
	case TSW750: //most other products will be in this case
		mxc_pwm_backlight_data.color_depth = 18;
		mxc_pwm_backlight_data.pixel_width = 800;
		mxc_pwm_backlight_data.pixel_height = 480;
		mxc_pwm_backlight_data.mm_width = 152;   //mm
		mxc_pwm_backlight_data.mm_height = 91;   //mm
		break;
			
	case TSW550:
		mxc_pwm_backlight_data.color_depth = 24;
		mxc_pwm_backlight_data.invert_brightness = 1; 
		mxc_pwm_backlight_data.pixel_width = 800;
		mxc_pwm_backlight_data.pixel_height = 400;
		mxc_pwm_backlight_data.mm_width = 108;
		mxc_pwm_backlight_data.mm_height = 65;
		break;
		
	case TST900:
		mxc_pwm_backlight_data.invert_brightness = 1; //dont really need to set since default
		mxc_pwm_backlight_data.color_depth = 18;
		mxc_pwm_backlight_data.pixel_width = 1024;  
		mxc_pwm_backlight_data.pixel_height = 600;
		mxc_pwm_backlight_data.mm_width = 195;
		mxc_pwm_backlight_data.mm_height = 113;
		break;
		
	default:
		printk(KERN_ERR "Invalid productId.\n");
	}

	mxc_register_device(&mxc_pwm1_backlight_device, &mxc_pwm_backlight_data);
	mxc_register_device(&mxc_ssi1_device, NULL);
	mxc_register_device(&mxc_ssi2_device, NULL);
//RJK	mxc_register_device(&mxc_alsa_spdif_device, &mxc_spdif_data);
	mxc_register_device(&mxc_android_pmem_device, &android_pmem_data);
	mxc_register_device(&mxc_android_pmem_gpu_device,
				&android_pmem_gpu_data);
#if 1 //sata?
	mxc_register_device(&ahci_fsl_device, &sata_data);
#endif
	mxc_register_device(&mxc_fec_device, &fec_data);
#if USE_UNKNOWN //precision time protocol
	mxc_register_device(&mxc_ptp_device, NULL);
#endif
	/* ASRC is only available for MX53 TO2.0 */
	if (mx53_revision() >= IMX_CHIP_REVISION_2_0) {
		mxc_asrc_data.asrc_core_clk = clk_get(NULL, "asrc_clk");
		clk_put(mxc_asrc_data.asrc_core_clk);
		mxc_asrc_data.asrc_audio_clk = clk_get(NULL, "asrc_serial_clk");
		clk_put(mxc_asrc_data.asrc_audio_clk);
		mxc_register_device(&mxc_asrc_device, &mxc_asrc_data);
	}

//RJK sgtl5000 code is doing aic32x4
#if 0 //RJK
	sgtl5000_data.ext_ram_clk = clk_get(NULL, "emi_fast_clk");
	clk_put(sgtl5000_data.ext_ram_clk);
	mxc_register_device(&mxc_sgtl5000_device, &sgtl5000_data);
#endif
	aic32x4_data.ext_ram_clk = clk_get(NULL, "emi_fast_clk");
	clk_put(aic32x4_data.ext_ram_clk);
	mxc_register_device(&mxc_aic32x4_device, &aic32x4_data);

//RJK 	spdif_audio_data.ext_ram_clk = clk_get(NULL, "emi_fast_clk");
//RJK	clk_put(spdif_audio_data.ext_ram_clk);
//RJK	mxc_register_device(&mxc_spdif_audio_device, &spdif_audio_data);
#if USE_UNKNOWN //video4linux
	mxc_register_device(&mxc_v4l2_device, NULL);
	mxc_register_device(&mxc_v4l2out_device, NULL);
#endif
	loco_add_device_buttons();
	pm_power_off = da9053_power_off;
	pm_i2c_init(I2C1_BASE_ADDR - MX53_OFFSET);

    switch(gProductId) {
		case TSW550: mxc_tsw550_board_init(); break;
		case TST600: mxc_tst600_board_init(); break;
		case TST900: mxc_tst900_board_init(); break;
		case TSW750: mxc_tsw750_board_init(); break;
		case TSW1050:mxc_tsw1050_board_init(); break;
		default: break;
    }
}

static void __init mx53_loco_timer_init(void)
{
	struct clk *uart_clk;

	mx53_clocks_init(32768, 24000000, 0, 0);

	uart_clk = clk_get_sys("mxcintuart.0", NULL);
	early_console_setup(MX53_BASE_ADDR(UART1_BASE_ADDR), uart_clk);
}

static struct sys_timer mxc_timer = {
	.init	= mx53_loco_timer_init,
};

static void __init fixup_android_board(struct machine_desc *desc, struct tag *tags,
				   char **cmdline, struct meminfo *mi)
{
	char *str;
	struct tag *t;
	struct tag *mem_tag = 0;
	int total_mem = SZ_1G;
	int left_mem = 0, avali_mem = 0;
	int gpu_mem = SZ_64M;
	int pmem_gpu_size = android_pmem_gpu_data.size;
	int pmem_adsp_size = android_pmem_data.size;

	mxc_set_cpu_type(MXC_CPU_MX53);

	/* get mem= and gpu_memory= from cmdline */
	for_each_tag(t, tags) {
		if (t->hdr.tag == ATAG_CMDLINE) {
			str = t->u.cmdline.cmdline;
			str = strstr(str, "mem=");
			if (str != NULL) {
				str += 4;
				avali_mem = memparse(str, &str);
			}

			str = t->u.cmdline.cmdline;
			str = strstr(str, "gpu_nommu");
			if (str != NULL)
				gpu_data.enable_mmu = 0;

			str = t->u.cmdline.cmdline;
			str = strstr(str, "gpu_memory=");
			if (str != NULL) {
				str += 11;
				gpu_mem = memparse(str, &str);
			}
			break;
		}
	}

	if (gpu_data.enable_mmu)
		gpu_mem = 0;

	/* get total memory from TAGS */
	for_each_tag(mem_tag, tags) {
		if (mem_tag->hdr.tag == ATAG_MEM) {
			total_mem = mem_tag->u.mem.size;
			left_mem = total_mem - gpu_mem
				- pmem_gpu_size - pmem_adsp_size;
			break;
		}
	}

	if (avali_mem > 0 && avali_mem < left_mem)
		left_mem = avali_mem;

	if (mem_tag) {
		android_pmem_data.start = mem_tag->u.mem.start
				+ left_mem + gpu_mem + pmem_gpu_size;
		android_pmem_gpu_data.start = mem_tag->u.mem.start
				+ left_mem + gpu_mem;
		mem_tag->u.mem.size = left_mem;

		/*reserve memory for gpu*/
		if (!gpu_data.enable_mmu) {
			gpu_device.resource[5].start =
				mem_tag->u.mem.start + left_mem;
			gpu_device.resource[5].end =
				gpu_device.resource[5].start + gpu_mem - 1;
		}
	}
}

/*
 * The following uses standard kernel macros define in arch.h in order to
 * initialize __mach_desc_MX53_LOCO data structure.
 */
MACHINE_START(MX53_LOCO, "Freescale MX53 LOCO Board")
	/* Maintainer: Freescale Semiconductor, Inc. */
#ifdef CONFIG_ANDROID_PMEM
	.fixup = fixup_android_board,
#else
	.fixup = fixup_mxc_board,
#endif
	.map_io = mx5_map_io,
	.init_irq = mx5_init_irq,
	.init_machine = mxc_board_init,
	.timer = &mxc_timer,
MACHINE_END
